/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.saxon;

import com.icl.saxon.ContentEmitter;
import com.icl.saxon.Context;
import com.icl.saxon.DOMDriver;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.style.StyleElement;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.krysalis.barcode.BarcodeException;
import org.krysalis.barcode.BarcodeGenerator;
import org.krysalis.barcode.BarcodeUtil;
import org.krysalis.barcode.output.svg.SVGCanvasProvider;
import org.krysalis.barcode.tools.ConfigurationUtil;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BarcodeStyleElement
extends StyleElement {
    private Logger log = new ConsoleLogger();
    private Expression message;

    public void prepareAttributes() throws TransformerConfigurationException {
        String msgAtt = this.attributeList.getValue("message");
        if (msgAtt == null) {
            this.reportAbsence("message");
        }
        this.message = this.makeAttributeValueTemplate(msgAtt);
    }

    public void process(Context context) throws TransformerException {
        Configuration cfg = ConfigurationUtil.buildConfiguration((Node)((Object)this));
        try {
            BarcodeGenerator gen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg, this.log);
            SVGCanvasProvider svg = cfg.getAttributeAsBoolean("useNamespace", true) ? new SVGCanvasProvider(cfg.getAttribute("prefix", "svg")) : new SVGCanvasProvider(false);
            gen.generateBarcode(svg, this.message.evaluateAsString(context));
            ContentEmitter ce = new ContentEmitter();
            ce.setEmitter(context.getOutputter().getEmitter());
            ce.setNamePool(NamePool.getDefaultNamePool());
            try {
                DOMDriver domdriver = new DOMDriver();
                domdriver.setStartNode((Node)svg.getDOMFragment());
                domdriver.setContentHandler((ContentHandler)ce);
                domdriver.parse();
            }
            catch (SAXException saxe) {
                throw new TransformerException(saxe);
            }
        }
        catch (BarcodeException be) {
            throw new TransformerException((Throwable)((Object)be));
        }
    }

    public boolean isInstruction() {
        return true;
    }
}

