/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.output.svg;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.output.BarcodeCanvasSetupException;
import org.krysalis.barcode.output.svg.AbstractSVGGeneratingCanvasProvider;
import org.w3c.dom.DocumentFragment;

public class JDOMSVGCanvasProvider
extends AbstractSVGGeneratingCanvasProvider {
    private Namespace ns;
    private Document doc;
    private Element detailGroup;

    public JDOMSVGCanvasProvider(String namespacePrefix) throws BarcodeCanvasSetupException {
        super(namespacePrefix);
    }

    public JDOMSVGCanvasProvider(boolean useNamespace) throws BarcodeCanvasSetupException {
        super(useNamespace);
        this.init();
    }

    public JDOMSVGCanvasProvider() throws BarcodeCanvasSetupException {
        this.init();
    }

    private void init() {
        this.ns = this.isNamespaceEnabled() ? (this.getNamespacePrefix() != null ? Namespace.getNamespace((String)this.getNamespacePrefix(), (String)"http://www.w3.org/2000/svg") : Namespace.getNamespace((String)"http://www.w3.org/2000/svg")) : null;
        Element svg = new Element("svg", this.ns);
        this.doc = new Document(svg);
        this.detailGroup = new Element("g", this.ns);
        svg.addContent(this.detailGroup);
        this.detailGroup.setAttribute("style", "fill:black; stroke:none");
    }

    public Document getDocument() {
        return this.doc;
    }

    public org.w3c.dom.Document getDOM() {
        DOMOutputter output = new DOMOutputter();
        try {
            return output.output(this.doc);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DocumentFragment getDOMFragment() {
        org.w3c.dom.Document doc = this.getDOM();
        DocumentFragment frag = doc.createDocumentFragment();
        frag.appendChild(doc.getDocumentElement());
        return frag;
    }

    public void establishDimensions(BarcodeDimension dim) {
        super.establishDimensions(dim);
        Element svg = this.doc.getRootElement();
        svg.setAttribute("width", this.addUnit(dim.getWidthPlusQuiet()));
        svg.setAttribute("height", this.addUnit(dim.getHeightPlusQuiet()));
    }

    public void deviceFillRect(double x, double y, double w, double h) {
        Element el = new Element("rect", this.ns);
        el.setAttribute("x", this.addUnit(x));
        el.setAttribute("y", this.addUnit(y));
        el.setAttribute("width", this.addUnit(w));
        el.setAttribute("height", this.addUnit(h));
        this.detailGroup.addContent(el);
    }

    public void deviceJustifiedText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        this.deviceCenteredText(text, x1, x2, y1, fontName, fontSize, true);
    }

    public void deviceCenteredText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        this.deviceCenteredText(text, x1, x2, y1, fontName, fontSize, false);
    }

    public void deviceCenteredText(String text, double x1, double x2, double y1, String fontName, double fontSize, boolean justify) {
        Element el = new Element("text", this.ns);
        el.setAttribute("style", "font-family:" + fontName + "; font-size:" + fontSize + "pt; text-anchor:middle");
        el.setAttribute("x", this.addUnit(x1 + (x2 - x1) / 2.0));
        el.setAttribute("y", this.addUnit(y1));
        if (justify) {
            el.setAttribute("textLength", this.addUnit(x2 - x1));
        }
        el.addContent(text);
        this.detailGroup.addContent(el);
    }
}

