/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.output.java2d;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.krysalis.barcode.output.AbstractCanvasProvider;
import org.krysalis.barcode.tools.UnitConv;

public class Java2DCanvasProvider
extends AbstractCanvasProvider {
    private static final boolean DEBUG = false;
    private Graphics2D g2d;

    public Java2DCanvasProvider(Graphics2D g2d) {
        this.g2d = g2d;
    }

    public void deviceFillRect(double x, double y, double w, double h) {
        this.g2d.fill(new Rectangle2D.Double(x, y, w, h));
    }

    public void deviceDrawRect(double x, double y, double w, double h) {
        this.g2d.draw(new Rectangle2D.Double(x, y, w, h));
    }

    public void deviceJustifiedText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        this.deviceCenteredText(text, x1, x2, y1, fontName, fontSize, true);
    }

    public void deviceCenteredText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        this.deviceCenteredText(text, x1, x2, y1, fontName, fontSize, false);
    }

    public void deviceCenteredText(String text, double x1, double x2, double y1, String fontName, double fontSize, boolean justify) {
        Font font = new Font(fontName, 0, (int)Math.round(UnitConv.pt2mm(fontSize)));
        FontRenderContext frc = this.g2d.getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, text);
        float textwidth = (float)gv.getLogicalBounds().getWidth();
        float distributableSpace = (float)(x2 - x1 - (double)textwidth);
        float intercharSpace = gv.getNumGlyphs() > 1 ? distributableSpace / (float)(gv.getNumGlyphs() - 1) : 0.0f;
        float indent = justify && text.length() > 1 ? 0.0f : distributableSpace / 2.0f;
        Font oldFont = this.g2d.getFont();
        this.g2d.setFont(font);
        if (justify) {
            float rx = 0.0f;
            int i = 0;
            while (i < gv.getNumGlyphs()) {
                Point2D point = gv.getGlyphPosition(i);
                point.setLocation(point.getX() + (double)((float)i * intercharSpace), point.getY());
                gv.setGlyphPosition(i, point);
                ++i;
            }
        }
        this.g2d.drawGlyphVector(gv, (float)x1 + indent, (float)y1);
        this.g2d.setFont(oldFont);
    }
}

