/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.output.bitmap;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.krysalis.barcode.output.bitmap.BitmapEncoder;

public class BitmapEncoderRegistry {
    private static Set encoders = new TreeSet();

    protected BitmapEncoderRegistry() {
        throw new UnsupportedOperationException();
    }

    private static void register(String classname, int priority, boolean complain) {
        boolean failed = false;
        try {
            Class<?> clazz = Class.forName(classname);
            BitmapEncoder encoder = (BitmapEncoder)clazz.newInstance();
            encoders.add(new Entry(encoder, priority));
        }
        catch (Exception e) {
            failed = true;
        }
        catch (LinkageError le) {
            failed = true;
        }
        if (failed) {
            if (complain) {
                throw new IllegalArgumentException("The implementation being registered is unavailable or cannot be instantiated: " + classname);
            }
            return;
        }
    }

    public static void register(String classname, int priority) {
        BitmapEncoderRegistry.register(classname, priority, true);
    }

    public static boolean supports(BitmapEncoder encoder, String mime) {
        String[] mimes = encoder.getSupportedMIMETypes();
        int i = 0;
        while (i < mimes.length) {
            if (mimes[i].equals(mime)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean supports(String mime) {
        Iterator i = encoders.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            BitmapEncoder encoder = entry.encoder;
            if (!BitmapEncoderRegistry.supports(encoder, mime)) continue;
            return true;
        }
        return false;
    }

    public static BitmapEncoder getInstance(String mime) {
        Iterator i = encoders.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            BitmapEncoder encoder = entry.encoder;
            if (!BitmapEncoderRegistry.supports(encoder, mime)) continue;
            return encoder;
        }
        throw new UnsupportedOperationException("No BitmapEncoder available for " + mime);
    }

    public static Set getSupportedMIMETypes() {
        HashSet<String> mimes = new HashSet<String>();
        Iterator i = encoders.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            BitmapEncoder encoder = entry.encoder;
            String[] s = encoder.getSupportedMIMETypes();
            int j = 0;
            while (j < s.length) {
                mimes.add(s[j]);
                ++j;
            }
        }
        return mimes;
    }

    static {
        BitmapEncoderRegistry.register("org.krysalis.barcode.output.bitmap.SunJPEGBitmapEncoder", 0, false);
        BitmapEncoderRegistry.register("org.krysalis.barcode.output.bitmap.ImageIOBitmapEncoder", 50, false);
    }

    private static class Entry
    implements Comparable {
        private BitmapEncoder encoder;
        private int priority;

        public Entry(BitmapEncoder encoder, int priority) {
            this.encoder = encoder;
            this.priority = priority;
        }

        public int compareTo(Object o) {
            Entry e = (Entry)o;
            return e.priority - this.priority;
        }
    }
}

