/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.impl.GenericBarcodeImpl;
import org.krysalis.barcode.impl.UPCEANCanvasLogicHandler;
import org.krysalis.barcode.impl.UPCEANLogicImpl;
import org.krysalis.barcode.output.Canvas;
import org.krysalis.barcode.output.CanvasProvider;
import org.krysalis.barcode.tools.Length;

public abstract class UPCEAN
extends GenericBarcodeImpl
implements Configurable {
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.33mm"), "mm");
        this.moduleWidth = mw.getValueAsMillimeter();
        super.configure(cfg);
        this.checksumMode = ChecksumMode.byName(cfg.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName()));
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getBarWidth(int width) {
        if (width >= 1 && width <= 4) {
            return (double)width * this.moduleWidth;
        }
        throw new IllegalArgumentException("Only widths 1 to 4 allowed");
    }

    public abstract UPCEANLogicImpl createLogicImpl();

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        UPCEANCanvasLogicHandler handler = new UPCEANCanvasLogicHandler(this, new Canvas(canvas));
        UPCEANLogicImpl impl = this.createLogicImpl();
        impl.generateBarcodeLogic(handler, msg);
    }

    protected double supplementalWidth(String msg) {
        double width = 0.0;
        int suppLen = UPCEANLogicImpl.getSupplementalLength(msg);
        if (suppLen > 0) {
            width += this.quietZone;
            width += 4.0 * this.moduleWidth;
            width += (double)(suppLen * 7) * this.moduleWidth;
            width += (double)((suppLen - 1) * 2) * this.moduleWidth;
        }
        return width;
    }

    public BarcodeDimension calcDimensions(String msg) {
        double width = 3.0 * this.moduleWidth;
        width += 42.0 * this.moduleWidth;
        width += 5.0 * this.moduleWidth;
        width += 42.0 * this.moduleWidth;
        width += 3.0 * this.moduleWidth;
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width += this.supplementalWidth(msg), this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }
}

