/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.BaselineAlignment;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.HumanReadablePlacement;
import org.krysalis.barcode.impl.DefaultHeightVariableLogicHandler;
import org.krysalis.barcode.impl.HeightVariableBarcodeImpl;
import org.krysalis.barcode.impl.POSTNETLogicImpl;
import org.krysalis.barcode.output.Canvas;
import org.krysalis.barcode.output.CanvasProvider;
import org.krysalis.barcode.tools.Length;

public class POSTNET
extends HeightVariableBarcodeImpl
implements Configurable {
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double intercharGapWidth = this.moduleWidth;
    private BaselineAlignment baselinePosition = BaselineAlignment.ALIGN_BOTTOM;
    private double shortBarHeight = 1.25;

    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.020in"), "mm");
        this.moduleWidth = mw.getValueAsMillimeter();
        super.configure(cfg);
        this.checksumMode = ChecksumMode.byName(cfg.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName()));
        Length igw = new Length(cfg.getChild("interchar-gap-width").getValue("0.026in"), "mm");
        this.intercharGapWidth = igw.getValueAsMillimeter();
        Length h = new Length(cfg.getChild("tall-bar-height").getValue("0.125in"), "mm");
        this.setBarHeight(h.getValueAsMillimeter());
        Length hbh = new Length(cfg.getChild("short-bar-height").getValue("0.050in"), "mm");
        this.shortBarHeight = hbh.getValueAsMillimeter();
        this.msgPos = HumanReadablePlacement.byName(cfg.getChild("human-readable").getValue(HumanReadablePlacement.HRP_NONE.getName()));
        this.baselinePosition = BaselineAlignment.byName(cfg.getChild("baseline-alignment").getValue(BaselineAlignment.ALIGN_BOTTOM.getName()));
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getBarWidth(int width) {
        if (width == 1) {
            return this.moduleWidth;
        }
        if (width == -1) {
            return this.intercharGapWidth;
        }
        throw new IllegalArgumentException("Only width 1 allowed");
    }

    public double getBarHeight(int height) {
        if (height == 2) {
            return this.getBarHeight();
        }
        if (height == 1) {
            return this.shortBarHeight;
        }
        if (height == -1) {
            return this.getBarHeight();
        }
        throw new IllegalArgumentException("Only height 0 or 1 allowed");
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultHeightVariableLogicHandler handler = new DefaultHeightVariableLogicHandler(this, new Canvas(canvas));
        POSTNETLogicImpl impl = new POSTNETLogicImpl(this.getChecksumMode());
        impl.generateBarcodeLogic(handler, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        String modMsg = POSTNETLogicImpl.removeIgnoredCharacters(msg);
        double width = (double)(modMsg.length() * 5 + 2) * this.moduleWidth + (double)(modMsg.length() * 5 + 1) * this.intercharGapWidth;
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        double height = this.getHeight();
        if (this.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
            height -= this.getHumanReadableHeight();
        }
        return new BarcodeDimension(width, height, width + 2.0 * qz, height, this.quietZone, 0.0);
    }

    public BaselineAlignment getBaselinePosition() {
        return this.baselinePosition;
    }

    public void setBaselinePosition(BaselineAlignment baselinePosition) {
        this.baselinePosition = baselinePosition;
    }
}

