/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.BarcodeGenerator;
import org.krysalis.barcode.HumanReadablePlacement;
import org.krysalis.barcode.output.Canvas;
import org.krysalis.barcode.output.CanvasProvider;
import org.krysalis.barcode.tools.Length;
import org.krysalis.barcode.tools.UnitConv;

public abstract class GenericBarcodeImpl
implements BarcodeGenerator,
Configurable {
    protected double height = 15.0;
    protected double moduleWidth;
    protected HumanReadablePlacement msgPos = HumanReadablePlacement.HRP_BOTTOM;
    protected double fontSize = 8.0;
    protected String fontName = "Helvetica";
    protected boolean doQuietZone = true;
    protected double quietZone;

    public void configure(Configuration cfg) throws ConfigurationException {
        Length h = new Length(cfg.getChild("height").getValue("15mm"), "mm");
        this.setHeight(h.getValueAsMillimeter());
        this.doQuietZone = cfg.getChild("quiet-zone").getAttributeAsBoolean("enabled", true);
        Length qz = new Length(cfg.getChild("quiet-zone").getValue("10mw"), "mw");
        this.quietZone = qz.getUnit().equalsIgnoreCase("mw") ? qz.getValue() * this.getModuleWidth() : qz.getValueAsMillimeter();
        this.msgPos = HumanReadablePlacement.byName(cfg.getChild("human-readable").getValue(HumanReadablePlacement.HRP_BOTTOM.getName()));
    }

    public double getHumanReadableHeight() {
        double textHeight = UnitConv.pt2mm(this.fontSize);
        return 1.0 * textHeight;
    }

    public double getBarHeight() {
        return this.height;
    }

    public double getHeight() {
        return this.getBarHeight() + this.getHumanReadableHeight();
    }

    public void setBarHeight(double height) {
        this.height = height;
    }

    public void setHeight(double height) {
        this.height = height - this.getHumanReadableHeight();
    }

    public double getModuleWidth() {
        return this.moduleWidth;
    }

    public void setModuleWidth(double width) {
        this.moduleWidth = width;
    }

    public abstract double getBarWidth(int var1);

    public boolean hasQuietZone() {
        return this.doQuietZone;
    }

    public void doQuietZone(boolean value) {
        this.doQuietZone = value;
    }

    public double getQuietZone() {
        return this.quietZone;
    }

    public HumanReadablePlacement getMsgPosition() {
        return this.msgPos;
    }

    public void setMsgPosition(HumanReadablePlacement placement) {
        this.msgPos = placement;
    }

    protected void drawCenteredChar(Canvas canvas, char ch, double x1, double x2, double y1) {
        canvas.drawCenteredChar(ch, x1, x2, y1 - UnitConv.pt2mm(this.fontSize) * 0.2, this.fontName, this.fontSize);
    }

    protected void drawJustifiedText(Canvas canvas, String text, double x1, double x2, double y1) {
        canvas.drawJustifiedText(text, x1, x2, y1 - UnitConv.pt2mm(this.fontSize) * 0.2, this.fontName, this.fontSize);
    }

    protected void drawCenteredText(Canvas canvas, String text, double x1, double x2, double y1) {
        canvas.drawCenteredText(text, x1, x2, y1 - UnitConv.pt2mm(this.fontSize) * 0.2, this.fontName, this.fontSize);
    }

    public abstract void generateBarcode(CanvasProvider var1, String var2);

    public BarcodeDimension calcDimensions(String msg) {
        throw new UnsupportedOperationException("NYI");
    }
}

