/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.krysalis.barcode.impl.Code128Encoder;
import org.krysalis.barcode.impl.Code128LogicImpl;

public class DefaultCode128Encoder
implements Code128Encoder {
    private static final int CODESET_A = 1;
    private static final int CODESET_B = 2;
    private static final int CODESET_C = 4;
    private static final int START_A = 103;
    private static final int START_B = 104;
    private static final int START_C = 105;
    private static final int GOTO_A = 101;
    private static final int GOTO_B = 100;
    private static final int GOTO_C = 99;
    private static final int FNC_1 = 102;
    private static final int FNC_2 = 97;
    private static final int FNC_3 = 96;
    private static final int SHIFT = 98;

    private final boolean inCodeset(char c, int codeset) {
        switch (codeset) {
            case 1: {
                return Code128LogicImpl.isInCodeSetA(c);
            }
            case 2: {
                return Code128LogicImpl.isInCodeSetB(c);
            }
            case 4: {
                return Code128LogicImpl.canBeInCodeSetC(c);
            }
        }
        throw new IllegalArgumentException("Invalid codeset");
    }

    private boolean needA(char c) {
        return c < ' ';
    }

    private boolean needB(char c) {
        return c >= '`' && c < '\u0080';
    }

    private int determineAorB(char c) {
        if (this.needA(c)) {
            return 1;
        }
        if (Code128LogicImpl.isInCodeSetB(c)) {
            return 2;
        }
        return 0;
    }

    private int getStartControl(int codeset) {
        switch (codeset) {
            case 1: {
                return 103;
            }
            case 2: {
                return 104;
            }
            case 4: {
                return 105;
            }
        }
        throw new IllegalArgumentException("Invalid codeset");
    }

    private boolean nextLotInCodeset(String msg, int startpos, int codeset, int count) {
        if (startpos + count > msg.length()) {
            return false;
        }
        int i = 0;
        while (i < count) {
            if (!this.inCodeset(msg.charAt(startpos + i), codeset)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int countCharsInSameCodeset(String msg, int startpos, int codeset) {
        int count = 0;
        while (startpos + count < msg.length()) {
            if (!this.inCodeset(msg.charAt(startpos + count), codeset)) break;
            ++count;
        }
        return count;
    }

    private int encodeAorB(char c, int codeset) {
        if (c == '\u00f1') {
            return 102;
        }
        if (c == '\u00f2') {
            return 97;
        }
        if (c == '\u00f3') {
            return 96;
        }
        if (c == '\u00f4') {
            if (codeset == 1) {
                return 101;
            }
            return 100;
        }
        if (codeset == 1) {
            if (c >= '\u0000' && c < ' ') {
                return c + 64;
            }
            if (c >= ' ' && c <= '_') {
                return c - 32;
            }
            throw new IllegalArgumentException("Illegal character: " + c);
        }
        if (codeset == 2) {
            if (c >= ' ' && c < '\u0080') {
                return c - 32;
            }
            throw new IllegalArgumentException("Illegal character: " + c);
        }
        throw new IllegalArgumentException("Only A or B allowed");
    }

    public int[] encode(String msg) {
        int currentCodeset;
        int[] encoded = new int[msg.length() * 2 + 5];
        int respos = 0;
        int msgpos = 0;
        if (msg.length() == 2 && this.nextLotInCodeset(msg, 0, 4, 2)) {
            currentCodeset = 4;
        } else if (msg.length() >= 4 && this.nextLotInCodeset(msg, 0, 4, 4)) {
            currentCodeset = 4;
        } else {
            currentCodeset = this.determineAorB(msg.charAt(0));
            if (currentCodeset == 0) {
                currentCodeset = 2;
            }
        }
        encoded[respos] = this.getStartControl(currentCodeset);
        ++respos;
        while (msgpos < msg.length()) {
            switch (currentCodeset) {
                case 4: {
                    if (msg.charAt(msgpos) == '\u00f1') {
                        encoded[respos] = 102;
                        ++respos;
                        ++msgpos;
                        break;
                    }
                    if (this.nextLotInCodeset(msg, msgpos, 4, 2)) {
                        encoded[respos] = Character.digit(msg.charAt(msgpos), 10) * 10 + Character.digit(msg.charAt(msgpos + 1), 10);
                        ++respos;
                        msgpos += 2;
                        break;
                    }
                    currentCodeset = this.determineAorB(msg.charAt(msgpos));
                    if (currentCodeset == 0) {
                        currentCodeset = 2;
                    }
                    encoded[respos] = currentCodeset == 1 ? 101 : 100;
                    ++respos;
                    break;
                }
                case 1: 
                case 2: {
                    int preview;
                    int c = this.countCharsInSameCodeset(msg, msgpos, 4);
                    if (c >= 4) {
                        if (c % 2 != 0) {
                            encoded[respos] = Character.digit(msg.charAt(msgpos), 10) + 16;
                            ++respos;
                            ++msgpos;
                        }
                        encoded[respos] = 99;
                        ++respos;
                        currentCodeset = 4;
                        break;
                    }
                    if (currentCodeset == 1 && this.needB(msg.charAt(msgpos))) {
                        if (msgpos + 1 < msg.length() && (preview = this.determineAorB(msg.charAt(msgpos + 1))) == 2) {
                            encoded[respos] = 100;
                            ++respos;
                            currentCodeset = 2;
                        }
                        if (currentCodeset != 1) break;
                        encoded[respos] = 98;
                        encoded[++respos] = this.encodeAorB(msg.charAt(msgpos), 2);
                        ++respos;
                        ++msgpos;
                        break;
                    }
                    if (currentCodeset == 2 && this.needA(msg.charAt(msgpos))) {
                        if (msgpos + 1 < msg.length() && (preview = this.determineAorB(msg.charAt(msgpos + 1))) == 1) {
                            encoded[respos] = 101;
                            ++respos;
                            currentCodeset = 1;
                        }
                        if (currentCodeset != 2) break;
                        encoded[respos] = 98;
                        encoded[++respos] = this.encodeAorB(msg.charAt(msgpos), 1);
                        ++respos;
                        ++msgpos;
                        break;
                    }
                    encoded[respos] = this.encodeAorB(msg.charAt(msgpos), currentCodeset);
                    ++respos;
                    ++msgpos;
                }
            }
        }
        int[] result = new int[respos];
        System.arraycopy(encoded, 0, result, 0, result.length);
        return result;
    }
}

