/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.krysalis.barcode.BarGroup;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.ClassicBarcodeLogicHandler;
import org.krysalis.barcode.HumanReadablePlacement;
import org.krysalis.barcode.impl.GenericBarcodeImpl;
import org.krysalis.barcode.output.Canvas;

public class DefaultCanvasLogicHandler
implements ClassicBarcodeLogicHandler {
    private GenericBarcodeImpl bcImpl;
    private Canvas canvas;
    private double x = 0.0;
    private String msg;
    private String lastgroup;

    public DefaultCanvasLogicHandler(GenericBarcodeImpl bcImpl, Canvas canvas) {
        this.bcImpl = bcImpl;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcImpl.hasQuietZone()) {
            return this.bcImpl.getQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String msg) {
        this.msg = msg;
        BarcodeDimension dim = this.bcImpl.calcDimensions(msg);
        this.canvas.establishDimensions(dim);
        this.x = this.getStartX();
    }

    public void startBarGroup(BarGroup type, String submsg) {
        this.lastgroup = submsg;
    }

    public void addBar(boolean black, int width) {
        double w = this.bcImpl.getBarWidth(width);
        if (black) {
            if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
                this.canvas.drawRectWH(this.x, 0.0, w, this.bcImpl.getHeight());
            } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                this.canvas.drawRectWH(this.x, this.bcImpl.getHumanReadableHeight(), w, this.bcImpl.getBarHeight());
            } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                this.canvas.drawRectWH(this.x, 0.0, w, this.bcImpl.getBarHeight());
            }
        }
        this.x += w;
    }

    public void endBarGroup() {
    }

    public void endBarcode() {
        if (this.bcImpl.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                this.bcImpl.drawCenteredText(this.canvas, this.msg, this.getStartX(), this.x, this.bcImpl.getHumanReadableHeight());
            } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                this.bcImpl.drawCenteredText(this.canvas, this.msg, this.getStartX(), this.x, this.bcImpl.getHeight());
            }
        }
    }
}

