/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.krysalis.barcode.BarGroup;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.ClassicBarcodeLogicHandler;

public class Code39LogicImpl {
    private static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '.', ' ', '$', '/', '+', '%', '*'};
    private static final char STARTSTOP = '*';
    private static final byte[][] CHARSET = new byte[][]{{0, 0, 0, 1, 1, 0, 1, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 0, 1}, {0, 0, 1, 1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 1}, {1, 0, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 1, 0, 1}, {1, 0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 1, 0, 0}, {1, 0, 0, 0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1, 0, 0, 1}, {1, 0, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 1, 0, 0, 0}, {0, 0, 1, 0, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1, 1}, {0, 0, 1, 0, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 1, 0, 0, 1, 1}, {1, 0, 0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 1, 1, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 0, 1}, {1, 1, 0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 0, 1, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 1, 0, 1}, {1, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 1, 0, 1, 0, 0, 0}, {0, 1, 0, 1, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 0, 1, 0}, {0, 1, 0, 0, 1, 0, 1, 0, 0}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public Code39LogicImpl(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public static char calcChecksum(String msg) {
        int checksum = 0;
        int i = 0;
        while (i < msg.length()) {
            int chidx = Code39LogicImpl.getCharIndex(msg.charAt(i));
            if (chidx >= 0) {
                checksum += chidx;
            } else {
                throw new IllegalArgumentException("Invalid character: " + msg.charAt(i));
            }
            ++i;
        }
        return CHARACTERS[checksum % 43];
    }

    public static boolean validateChecksum(String msg) {
        char expected;
        char actual = msg.charAt(msg.length() - 1);
        return actual == (expected = Code39LogicImpl.calcChecksum(msg.substring(0, msg.length() - 1)));
    }

    private static int getCharIndex(char ch) {
        char effch = ch >= 'a' && ch <= 'z' ? Character.toUpperCase(ch) : ch;
        int i = 0;
        while (i < CHARACTERS.length) {
            if (effch == CHARACTERS[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isValidChar(char ch) {
        if (ch == '*') {
            return false;
        }
        return Code39LogicImpl.getCharIndex(ch) >= 0;
    }

    private int widthAt(char ch, int index) {
        int chidx = Code39LogicImpl.getCharIndex(ch);
        if (chidx >= 0) {
            byte binary = CHARSET[chidx][index];
            return binary + 1;
        }
        throw new IllegalArgumentException("Invalid character: " + ch);
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, char c) {
        logic.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        int i = 0;
        while (i < 9) {
            int width = this.widthAt(c, i);
            boolean black = i % 2 == 0;
            logic.addBar(black, width);
            i = (byte)(i + 1);
        }
        logic.endBarGroup();
    }

    private void addIntercharacterGap(ClassicBarcodeLogicHandler logic) {
        logic.addBar(false, -1);
    }

    private void handleChecksum(StringBuffer sb) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            sb.append(Code39LogicImpl.calcChecksum(sb.toString()));
        } else if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!Code39LogicImpl.validateChecksum(sb.toString())) {
                throw new IllegalArgumentException("Message '" + sb.toString() + "' has a bad checksum. Expected: " + Code39LogicImpl.calcChecksum(sb.toString()));
            }
        } else {
            if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
                return;
            }
            if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
                return;
            }
        }
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        logic.startBarcode(msg);
        StringBuffer sb = new StringBuffer(msg);
        this.handleChecksum(sb);
        logic.startBarGroup(BarGroup.START_CHARACTER, new Character('*').toString());
        this.encodeChar(logic, '*');
        logic.endBarGroup();
        int i = 0;
        while (i < sb.length()) {
            this.addIntercharacterGap(logic);
            char ch = sb.charAt(i);
            if (!Code39LogicImpl.isValidChar(ch)) {
                throw new IllegalArgumentException("Invalid character: " + ch);
            }
            this.encodeChar(logic, ch);
            ++i;
        }
        this.addIntercharacterGap(logic);
        logic.startBarGroup(BarGroup.STOP_CHARACTER, new Character('*').toString());
        this.encodeChar(logic, '*');
        logic.endBarGroup();
        logic.endBarcode();
    }
}

