/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.impl.Code39LogicImpl;
import org.krysalis.barcode.impl.DefaultCanvasLogicHandler;
import org.krysalis.barcode.impl.GenericBarcodeImpl;
import org.krysalis.barcode.output.Canvas;
import org.krysalis.barcode.output.CanvasProvider;
import org.krysalis.barcode.tools.Length;

public class Code39
extends GenericBarcodeImpl
implements Configurable {
    protected static final double DEFAULT_WIDE_FACTOR = 2.5;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double intercharGapWidth = this.moduleWidth;
    private double wideFactor = 2.5;

    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.19mm"), "mm");
        this.moduleWidth = mw.getValueAsMillimeter();
        super.configure(cfg);
        this.checksumMode = ChecksumMode.byName(cfg.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName()));
        this.wideFactor = cfg.getChild("wide-factor").getValueAsFloat(2.5f);
        Length igw = new Length(cfg.getChild("interchar-gap-width").getValue("1mw"), "mw");
        this.intercharGapWidth = igw.getUnit().equalsIgnoreCase("mw") ? igw.getValue() * this.getModuleWidth() : igw.getValueAsMillimeter();
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getBarWidth(int width) {
        if (width == 1) {
            return this.moduleWidth;
        }
        if (width == 2) {
            return this.moduleWidth * this.wideFactor;
        }
        if (width == -1) {
            return this.intercharGapWidth;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler handler = new DefaultCanvasLogicHandler(this, new Canvas(canvas));
        Code39LogicImpl impl = new Code39LogicImpl(this.getChecksumMode());
        impl.generateBarcodeLogic(handler, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        double width = (double)(msg.length() + 2) * (3.0 * this.wideFactor + 6.0) * this.moduleWidth + (double)(msg.length() + 1) * this.intercharGapWidth;
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }
}

