/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.impl.Code128LogicImpl;
import org.krysalis.barcode.impl.DefaultCanvasLogicHandler;
import org.krysalis.barcode.impl.GenericBarcodeImpl;
import org.krysalis.barcode.output.Canvas;
import org.krysalis.barcode.output.CanvasProvider;
import org.krysalis.barcode.tools.Length;

public class Code128
extends GenericBarcodeImpl
implements Configurable {
    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.21mm"), "mm");
        this.moduleWidth = mw.getValueAsMillimeter();
        super.configure(cfg);
    }

    public double getBarWidth(int width) {
        if (width >= 1 && width <= 4) {
            return (double)width * this.moduleWidth;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public BarcodeDimension calcDimensions(String msg) {
        Code128LogicImpl impl = new Code128LogicImpl();
        int msgLen = impl.createEncodedMessage(msg).length + 1;
        double width = (double)(msgLen * 11 + 13) * this.getModuleWidth();
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler handler = new DefaultCanvasLogicHandler(this, new Canvas(canvas));
        Code128LogicImpl impl = new Code128LogicImpl();
        impl.generateBarcodeLogic(handler, msg);
    }
}

