/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.krysalis.barcode.BarcodeClassResolver;
import org.krysalis.barcode.BarcodeException;
import org.krysalis.barcode.BarcodeGenerator;
import org.krysalis.barcode.DefaultBarcodeClassResolver;
import org.krysalis.barcode.output.svg.SVGCanvasProvider;
import org.w3c.dom.DocumentFragment;

public class BarcodeUtil {
    private static BarcodeUtil instance = null;
    private BarcodeClassResolver classResolver = new DefaultBarcodeClassResolver();

    protected BarcodeUtil() {
    }

    public static BarcodeUtil getInstance() {
        if (instance == null) {
            instance = new BarcodeUtil();
        }
        return instance;
    }

    public static BarcodeGenerator createBarcodeGenerator(Configuration cfg, Logger logger, BarcodeClassResolver classResolver) throws BarcodeException {
        try {
            Class cl = null;
            String type = cfg.getName();
            try {
                cl = classResolver.resolve(type);
            }
            catch (ClassNotFoundException cnfe) {
                cl = null;
            }
            Configuration child = null;
            if (cl == null) {
                Configuration[] children = cfg.getChildren();
                if (children.length == 0) {
                    throw new BarcodeException("Barcode configuration element expected");
                }
                int i = 0;
                while (i < children.length) {
                    child = children[i];
                    type = child.getName();
                    try {
                        cl = classResolver.resolve(type);
                        break;
                    }
                    catch (ClassNotFoundException cnfe) {
                        cl = null;
                        ++i;
                    }
                }
            }
            if (cl == null) {
                throw new BarcodeException("No barcode configuration element not found");
            }
            BarcodeGenerator gen = (BarcodeGenerator)cl.newInstance();
            if (gen instanceof LogEnabled) {
                ((LogEnabled)gen).enableLogging(logger);
            }
            if (gen instanceof Configurable) {
                ((Configurable)gen).configure(child != null ? child : cfg);
            }
            if (gen instanceof Initializable) {
                ((Initializable)gen).initialize();
            }
            return gen;
        }
        catch (Exception e) {
            throw new BarcodeException("Error instantiating a barcode generator", e);
        }
    }

    public BarcodeGenerator createBarcodeGenerator(Configuration cfg, Logger logger) throws BarcodeException {
        return BarcodeUtil.createBarcodeGenerator(cfg, logger, this.classResolver);
    }

    public DocumentFragment generateBarcode(Configuration cfg, Logger logger, String msg) throws BarcodeException {
        BarcodeGenerator gen = this.createBarcodeGenerator(cfg, logger);
        try {
            SVGCanvasProvider svg = new SVGCanvasProvider(false);
            gen.generateBarcode(svg, msg);
            return svg.getDOMFragment();
        }
        catch (Exception e) {
            throw new BarcodeException("Error while generating barcode", e);
        }
    }
}

