/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly.jruby;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.Script;
import org.jruby.RubyClass;
import org.jruby.embed.ScriptingContainer;
import org.kohsuke.stapler.jelly.jruby.RubyTemplateLanguage;

public class RubyTemplateContainer {
    private final RubyClass scriptClass;
    public final RubyTemplateLanguage language;
    public final ScriptingContainer container;

    public RubyTemplateContainer(RubyClass scriptClass, RubyTemplateLanguage language, ScriptingContainer container) {
        this.scriptClass = scriptClass;
        this.language = language;
        this.container = container;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Not relevant in this situation.")
    public Script parseScript(URL path) throws IOException {
        try {
            String template = IOUtils.toString((InputStream)path.openStream(), (Charset)StandardCharsets.UTF_8);
            return (Script)this.container.callMethod((Object)this.scriptClass, "new", new Object[]{template});
        }
        catch (Exception e) {
            throw new IOException("Failed to parse " + path, e);
        }
    }
}

