/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementScanner6;
import org.kohsuke.stapler.AbstractProcessorImpl;
import org.kohsuke.stapler.DataBoundConstructor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"*"})
public class ConstructorProcessor6
extends AbstractProcessorImpl {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ElementScanner6<Void, Void> scanner = new ElementScanner6<Void, Void>(){

            @Override
            public Void visitExecutable(ExecutableElement e, Void aVoid) {
                if (e.getAnnotation(DataBoundConstructor.class) != null) {
                    ConstructorProcessor6.this.write(e);
                } else {
                    String javadoc = ConstructorProcessor6.this.getJavadoc(e);
                    if (javadoc != null && javadoc.contains("@stapler-constructor")) {
                        ConstructorProcessor6.this.write(e);
                    }
                }
                return (Void)super.visitExecutable(e, aVoid);
            }
        };
        for (Element element : roundEnv.getRootElements()) {
            scanner.scan(element, null);
        }
        return false;
    }

    private void write(ExecutableElement c) {
        try {
            StringBuilder buf = new StringBuilder();
            for (VariableElement variableElement : c.getParameters()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(variableElement.getSimpleName());
            }
            TypeElement t = (TypeElement)c.getEnclosingElement();
            String string = t.getQualifiedName().toString().replace('.', '/') + ".stapler";
            this.notice("Generating " + string, c);
            Properties p = new Properties();
            p.put("constructor", buf.toString());
            this.writePropertyFile(p, string);
        }
        catch (IOException x) {
            this.error(x.toString());
        }
    }
}

