/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.kohsuke.github.GHDeploymentState;
import org.kohsuke.github.GHDeploymentStatus;
import org.kohsuke.github.GHDeploymentStatusBuilder;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHDeployment
extends GHObject {
    private GHRepository owner;
    protected String sha;
    protected String ref;
    protected String task;
    protected Object payload;
    protected String environment;
    protected String description;
    protected String statuses_url;
    protected String repository_url;
    protected GHUser creator;
    protected String original_environment;
    protected boolean transient_environment;
    protected boolean production_environment;

    GHDeployment wrap(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    public URL getStatusesUrl() {
        return GitHubClient.parseURL(this.statuses_url);
    }

    public URL getRepositoryUrl() {
        return GitHubClient.parseURL(this.repository_url);
    }

    public String getTask() {
        return this.task;
    }

    public String getPayload() {
        return (String)this.payload;
    }

    public Map<String, Object> getPayloadMap() {
        return Collections.unmodifiableMap((Map)this.payload);
    }

    public Object getPayloadObject() {
        return this.payload;
    }

    public String getOriginalEnvironment() {
        return this.original_environment;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public boolean isTransientEnvironment() {
        return this.transient_environment;
    }

    public boolean isProductionEnvironment() {
        return this.production_environment;
    }

    public GHUser getCreator() throws IOException {
        return this.root().intern(this.creator);
    }

    public String getRef() {
        return this.ref;
    }

    public String getSha() {
        return this.sha;
    }

    public GHDeploymentStatusBuilder createStatus(GHDeploymentState state) {
        return new GHDeploymentStatusBuilder(this.owner, this.getId(), state);
    }

    public PagedIterable<GHDeploymentStatus> listStatuses() {
        return ((Requester)this.root().createRequest().withUrlPath(this.statuses_url, new String[0])).toIterable(GHDeploymentStatus[].class, item -> item.lateBind(this.owner));
    }

    GHRepository getOwner() {
        return this.owner;
    }
}

