/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHVerification;
import org.kohsuke.github.GitHubBridgeAdapterObject;
import org.kohsuke.github.GitUser;

@SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
public class GitCommit
extends GitHubBridgeAdapterObject {
    private GitUser author;
    private GitUser committer;
    private String message;
    private GHRepository owner;
    private List<GHCommit.Parent> parents;
    private String sha;
    private String nodeId;
    private String url;
    private String htmlUrl;
    private Tree tree;
    private GHVerification verification;

    public GitCommit() {
    }

    GitCommit(GitCommit commit) {
        this.owner = commit.getOwner();
        this.sha = commit.getSha();
        this.nodeId = commit.getNodeId();
        this.url = commit.getUrl();
        this.htmlUrl = commit.getHtmlUrl();
        this.author = commit.getAuthor();
        this.committer = commit.getCommitter();
        this.message = commit.getMessage();
        this.verification = commit.getVerification();
        this.tree = commit.getTree();
        this.parents = commit.getParents();
    }

    public GitUser getAuthor() {
        return this.author;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getAuthoredDate() {
        return this.author.getDate();
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getCommitDate() {
        return this.committer.getDate();
    }

    public GitUser getCommitter() {
        return this.committer;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public String getMessage() {
        return this.message;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getOwner() {
        return this.owner;
    }

    public List<String> getParentSHA1s() {
        if (this.parents == null || this.parents.size() == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return GitCommit.this.parents.get((int)index).sha;
            }

            @Override
            public int size() {
                return GitCommit.this.parents.size();
            }
        };
    }

    public String getSHA1() {
        return this.sha;
    }

    public String getSha() {
        return this.sha;
    }

    public String getTreeSHA1() {
        return this.tree.getSha();
    }

    public String getTreeUrl() {
        return this.tree.getUrl();
    }

    public String getUrl() {
        return this.url;
    }

    public GHVerification getVerification() {
        return this.verification;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="acceptable")
    List<GHCommit.Parent> getParents() {
        return this.parents;
    }

    Tree getTree() {
        return this.tree;
    }

    GHCommit toGHCommit() {
        return new GHCommit(new GHCommit.ShortInfo(this));
    }

    GitCommit wrapUp(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    static class Tree {
        String sha;
        String url;

        Tree() {
        }

        public String getSha() {
            return this.sha;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

