/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import org.kohsuke.github.GHMilestoneState;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Requester;

public class GHMilestone
extends GHObject {
    private int closedIssues;
    private int openIssues;
    private int number;
    private String state;
    private String dueOn;
    private String title;
    private String description;
    private String htmlUrl;
    protected String closedAt;
    GHUser creator;
    GHRepository owner;

    public void close() throws IOException {
        this.edit("state", "closed");
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getClosedAt() {
        return GitHubClient.parseInstant(this.closedAt);
    }

    public int getClosedIssues() {
        return this.closedIssues;
    }

    public GHUser getCreator() {
        return this.root().intern(this.creator);
    }

    public String getDescription() {
        return this.description;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getDueOn() {
        return GitHubClient.parseInstant(this.dueOn);
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public int getNumber() {
        return this.number;
    }

    public int getOpenIssues() {
        return this.openIssues;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getOwner() {
        return this.owner;
    }

    public GHMilestoneState getState() {
        return Enum.valueOf(GHMilestoneState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public String getTitle() {
        return this.title;
    }

    public void reopen() throws IOException {
        this.edit("state", "open");
    }

    public void setDescription(String description) throws IOException {
        this.edit("description", description);
    }

    @Deprecated
    public void setDueOn(Date dueOn) throws IOException {
        this.setDueOn(GitHubClient.toInstantOrNull(dueOn));
    }

    public void setDueOn(Instant dueOn) throws IOException {
        this.edit("due_on", GitHubClient.printInstant(dueOn));
    }

    public void setTitle(String title) throws IOException {
        this.edit("title", title);
    }

    private void edit(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().with(key, value)).method("PATCH")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    protected String getApiRoute() {
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/milestones/" + this.number;
    }

    GHMilestone lateBind(GHRepository repo) {
        this.owner = repo;
        return this;
    }
}

