/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHGistFile;
import org.kohsuke.github.GHGistUpdater;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHGist
extends GHObject {
    private int comments;
    private String commentsUrl;
    private String description;
    private final Map<String, GHGistFile> files;
    private String forksUrl;
    private String commitsUrl;
    private String id;
    private String gitPullUrl;
    private String gitPushUrl;
    private String htmlUrl;
    @JsonProperty(value="public")
    private boolean isPublic;
    final GHUser owner;

    @JsonCreator
    private GHGist(@JsonProperty(value="owner") GHUser owner, @JsonProperty(value="files") Map<String, GHGistFile> files) {
        for (Map.Entry<String, GHGistFile> e : files.entrySet()) {
            e.getValue().fileName = e.getKey();
        }
        this.files = Collections.unmodifiableMap(files);
        this.owner = owner.root().getUser(owner);
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath("/gists/" + this.id, new String[0])).send();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GHGist ghGist = (GHGist)o;
        return this.id.equals(ghGist.id);
    }

    public GHGist fork() throws IOException {
        return ((Requester)((Requester)this.root().createRequest().method("POST")).withUrlPath(this.getApiTailUrl("forks"), new String[0])).fetch(GHGist.class);
    }

    public int getCommentCount() {
        return this.comments;
    }

    public String getCommentsUrl() {
        return this.commentsUrl;
    }

    public String getCommitsUrl() {
        return this.commitsUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public GHGistFile getFile(String name) {
        return this.files.get(name);
    }

    public Map<String, GHGistFile> getFiles() {
        return Collections.unmodifiableMap(this.files);
    }

    public String getForksUrl() {
        return this.forksUrl;
    }

    public String getGistId() {
        return this.id;
    }

    public String getGitPullUrl() {
        return this.gitPullUrl;
    }

    public String getGitPushUrl() {
        return this.gitPushUrl;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    @Override
    @Deprecated
    public long getId() {
        return Long.parseLong(this.getGistId());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getOwner() {
        return this.owner;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isStarred() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("star"), new String[0])).fetchHttpStatusCode() / 100 == 2;
    }

    public PagedIterable<GHGist> listForks() {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("forks"), new String[0])).toIterable(GHGist[].class, null);
    }

    public void star() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("PUT")).withUrlPath(this.getApiTailUrl("star"), new String[0])).send();
    }

    public void unstar() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiTailUrl("star"), new String[0])).send();
    }

    public GHGistUpdater update() {
        return new GHGistUpdater(this);
    }

    String getApiTailUrl(String tail) {
        String result = "/gists/" + this.id;
        if (!StringUtils.isBlank((CharSequence)tail)) {
            result = result + StringUtils.prependIfMissing((String)tail, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return result;
    }
}

