/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JacksonInject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

public class GHCompare {
    private String url;
    private String htmlUrl;
    private String permalinkUrl;
    private String diffUrl;
    private String patchUrl;
    private Status status;
    private int aheadBy;
    private int behindBy;
    private int totalCommits;
    private Commit baseCommit;
    private Commit mergeBaseCommit;
    private Commit[] commits;
    private GHCommit.File[] files;
    private GHRepository owner;
    @JacksonInject(value="GHCompare_usePaginatedCommits")
    private boolean usePaginatedCommits;

    public URL getUrl() {
        return GitHubClient.parseURL(this.url);
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public URL getPermalinkUrl() {
        return GitHubClient.parseURL(this.permalinkUrl);
    }

    public URL getDiffUrl() {
        return GitHubClient.parseURL(this.diffUrl);
    }

    public URL getPatchUrl() {
        return GitHubClient.parseURL(this.patchUrl);
    }

    public Status getStatus() {
        return this.status;
    }

    public int getAheadBy() {
        return this.aheadBy;
    }

    public int getBehindBy() {
        return this.behindBy;
    }

    public int getTotalCommits() {
        return this.totalCommits;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public Commit getBaseCommit() {
        return this.baseCommit;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public Commit getMergeBaseCommit() {
        return this.mergeBaseCommit;
    }

    public Commit[] getCommits() {
        try {
            return this.listCommits().withPageSize(100).toArray();
        }
        catch (IOException e) {
            throw new GHException(e.getMessage(), e);
        }
    }

    public PagedIterable<Commit> listCommits() {
        if (this.usePaginatedCommits) {
            return new GHCompareCommitsIterable();
        }
        return new PagedIterable<Commit>(){

            @Override
            @Nonnull
            public PagedIterator<Commit> _iterator(int pageSize) {
                return new PagedIterator<Commit>(Collections.singleton(GHCompare.this.commits).iterator(), null);
            }
        };
    }

    public GHCommit.File[] getFiles() {
        GHCommit.File[] newValue = new GHCommit.File[this.files.length];
        System.arraycopy(this.files, 0, newValue, 0, this.files.length);
        return newValue;
    }

    GHCompare lateBind(GHRepository owner) {
        this.owner = owner;
        for (Commit commit : this.commits) {
            commit.wrapUp(owner);
        }
        this.mergeBaseCommit.wrapUp(owner);
        this.baseCommit.wrapUp(owner);
        return this;
    }

    public static enum Status {
        behind,
        ahead,
        identical,
        diverged;

    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class Commit
    extends GHCommit {
        private InnerCommit commit;

        public InnerCommit getCommit() {
            return this.commit;
        }
    }

    class GHCompareCommitsIterable
    extends PagedIterable<Commit> {
        private GHCompare result;

        @Override
        @Nonnull
        public PagedIterator<Commit> _iterator(int pageSize) {
            GitHubRequest request = ((Requester)((Requester)GHCompare.this.owner.root().createRequest().injectMappingValue("GHCompare_usePaginatedCommits", GHCompare.this.usePaginatedCommits)).withUrlPath(GHCompare.this.owner.getApiTailUrl(GHCompare.this.url.substring(GHCompare.this.url.lastIndexOf("/compare/"))), new String[0])).build();
            if (pageSize == 0) {
                pageSize = 10;
            }
            return new PagedIterator<Commit>(this.adapt(GitHubPageIterator.create(GHCompare.this.owner.root().getClient(), GHCompare.class, request, pageSize)), item -> item.wrapUp(GHCompare.this.owner));
        }

        protected Iterator<Commit[]> adapt(final Iterator<GHCompare> base) {
            return new Iterator<Commit[]>(){

                @Override
                public boolean hasNext() {
                    return base.hasNext();
                }

                @Override
                public Commit[] next() {
                    GHCompare v = (GHCompare)base.next();
                    if (GHCompareCommitsIterable.this.result == null) {
                        GHCompareCommitsIterable.this.result = v;
                    }
                    return v.commits;
                }
            };
        }
    }

    public static class Tree {
        private String url;
        private String sha;

        public String getUrl() {
            return this.url;
        }

        public String getSha() {
            return this.sha;
        }
    }

    public static class InnerCommit {
        private String url;
        private String sha;
        private String message;
        private GitUser author;
        private GitUser committer;
        private Tree tree;

        public String getUrl() {
            return this.url;
        }

        public String getSha() {
            return this.sha;
        }

        public String getMessage() {
            return this.message;
        }

        public GitUser getAuthor() {
            return this.author;
        }

        public GitUser getCommitter() {
            return this.committer;
        }

        public Tree getTree() {
            return this.tree;
        }
    }
}

