/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHCommitFileIterable;
import org.kohsuke.github.GHCommitStatus;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitCommit;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHCommit {
    private GHRepository owner;
    private ShortInfo commit;
    String url;
    String htmlUrl;
    String sha;
    String message;
    List<File> files;
    Stats stats;
    List<Parent> parents;
    User author;
    User committer;

    public GHCommit() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="acceptable")
    GHCommit(ShortInfo shortInfo) {
        this.commit = shortInfo;
        this.owner = this.commit.getOwner();
        this.htmlUrl = this.commit.getHtmlUrl();
        this.sha = this.commit.getSha();
        this.url = this.commit.getUrl();
        this.parents = this.commit.getParents();
        this.message = this.commit.getMessage();
    }

    public ShortInfo getCommitShortInfo() throws IOException {
        if (this.commit == null) {
            this.populate();
        }
        return this.commit;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getOwner() {
        return this.owner;
    }

    public int getLinesChanged() throws IOException {
        this.populate();
        return this.stats.total;
    }

    public int getLinesAdded() throws IOException {
        this.populate();
        return this.stats.additions;
    }

    public int getLinesDeleted() throws IOException {
        this.populate();
        return this.stats.deletions;
    }

    public GHTree getTree() throws IOException {
        return this.owner.getTree(this.getCommitShortInfo().getTreeSHA1());
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public String getSHA1() {
        return this.sha;
    }

    public URL getUrl() {
        return GitHubClient.parseURL(this.url);
    }

    public PagedIterable<File> listFiles() throws IOException {
        this.populate();
        return new GHCommitFileIterable(this.owner, this.sha, this.files);
    }

    public List<String> getParentSHA1s() {
        if (this.parents == null || this.parents.size() == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return GHCommit.this.parents.get((int)index).sha;
            }

            @Override
            public int size() {
                return GHCommit.this.parents.size();
            }
        };
    }

    public List<GHCommit> getParents() throws IOException {
        this.populate();
        ArrayList<GHCommit> r = new ArrayList<GHCommit>();
        for (String sha1 : this.getParentSHA1s()) {
            r.add(this.owner.getCommit(sha1));
        }
        return r;
    }

    public GHUser getAuthor() throws IOException {
        this.populate();
        return this.resolveUser(this.author);
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getAuthoredDate() throws IOException {
        return this.getCommitShortInfo().getAuthoredDate();
    }

    public GHUser getCommitter() throws IOException {
        this.populate();
        return this.resolveUser(this.committer);
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getCommitDate() throws IOException {
        return this.getCommitShortInfo().getCommitDate();
    }

    private GHUser resolveUser(User author) throws IOException {
        if (author == null || author.login == null) {
            return null;
        }
        return this.owner.root().getUser(author.login);
    }

    public PagedIterable<GHPullRequest> listPullRequests() {
        return ((Requester)this.owner.root().createRequest().withUrlPath(String.format("/repos/%s/%s/commits/%s/pulls", this.owner.getOwnerName(), this.owner.getName(), this.sha), new String[0])).toIterable(GHPullRequest[].class, item -> item.wrapUp(this.owner));
    }

    public PagedIterable<GHBranch> listBranchesWhereHead() {
        return ((Requester)this.owner.root().createRequest().withUrlPath(String.format("/repos/%s/%s/commits/%s/branches-where-head", this.owner.getOwnerName(), this.owner.getName(), this.sha), new String[0])).toIterable(GHBranch[].class, item -> item.wrap(this.owner));
    }

    public PagedIterable<GHCommitComment> listComments() {
        return this.owner.listCommitComments(this.sha);
    }

    public GHCommitComment createComment(String body, String path, Integer line, Integer position) throws IOException {
        GHCommitComment r = ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).with("body", body)).with("path", path)).with("line", line)).with("position", position)).withUrlPath(String.format("/repos/%s/%s/commits/%s/comments", this.owner.getOwnerName(), this.owner.getName(), this.sha), new String[0])).fetch(GHCommitComment.class);
        return r.wrap(this.owner);
    }

    public GHCommitComment createComment(String body) throws IOException {
        return this.createComment(body, null, null, null);
    }

    public PagedIterable<GHCommitStatus> listStatuses() throws IOException {
        return this.owner.listCommitStatuses(this.sha);
    }

    public GHCommitStatus getLastStatus() throws IOException {
        return this.owner.getLastCommitStatus(this.sha);
    }

    public PagedIterable<GHCheckRun> getCheckRuns() throws IOException {
        return this.owner.getCheckRuns(this.sha);
    }

    void populate() throws IOException {
        if (this.files == null && this.stats == null) {
            ((Requester)this.owner.root().createRequest().withUrlPath(this.owner.getApiTailUrl("commits/" + this.sha), new String[0])).fetchInto(this);
        }
    }

    GHCommit wrapUp(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class ShortInfo
    extends GitCommit {
        private int commentCount = -1;

        public int getCommentCount() throws GHException {
            if (this.commentCount < 0) {
                throw new GHException("Not available on this endpoint.");
            }
            return this.commentCount;
        }

        public ShortInfo() {
        }

        ShortInfo(GitCommit commit) {
            super(commit);
        }

        @Override
        public List<String> getParentSHA1s() {
            List<String> shortInfoParents = super.getParentSHA1s();
            if (shortInfoParents == null) {
                throw new GHException("Not available on this endpoint. Try calling getParentSHA1s from outer class.");
            }
            return shortInfoParents;
        }
    }

    public static class Stats {
        int total;
        int additions;
        int deletions;
    }

    static class User {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String url;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String avatarUrl;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String gravatarId;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        int id;
        String login;

        User() {
        }
    }

    public static class Parent {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String url;
        String sha;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="It's being initialized by JSON deserialization")
    public static class File {
        String status;
        int changes;
        int additions;
        int deletions;
        String rawUrl;
        String blobUrl;
        String sha;
        String patch;
        String filename;
        String previousFilename;

        public int getLinesChanged() {
            return this.changes;
        }

        public int getLinesAdded() {
            return this.additions;
        }

        public int getLinesDeleted() {
            return this.deletions;
        }

        public String getStatus() {
            return this.status;
        }

        @SuppressFBWarnings(value={"NM_CONFUSING"}, justification="It's a part of the library's API and cannot be renamed")
        public String getFileName() {
            return this.filename;
        }

        public String getPreviousFilename() {
            return this.previousFilename;
        }

        public String getPatch() {
            return this.patch;
        }

        public URL getRawUrl() {
            return GitHubClient.parseURL(this.rawUrl);
        }

        public URL getBlobUrl() {
            return GitHubClient.parseURL(this.blobUrl);
        }

        public String getSha() {
            return this.sha;
        }
    }
}

