/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHException;
import org.kohsuke.github.PagedIterator;

public abstract class PagedIterable<T>
implements Iterable<T> {
    private int pageSize = 0;

    public PagedIterable<T> withPageSize(int size) {
        this.pageSize = size;
        return this;
    }

    @Override
    @Nonnull
    public final PagedIterator<T> iterator() {
        return this._iterator(this.pageSize);
    }

    @Nonnull
    public abstract PagedIterator<T> _iterator(int var1);

    protected T[] toArray(PagedIterator<T> iterator) throws IOException {
        try {
            T[] item;
            ArrayList<T[]> pages = new ArrayList<T[]>();
            int totalSize = 0;
            do {
                item = iterator.nextPageArray();
                totalSize += Array.getLength(item);
                pages.add(item);
            } while (iterator.hasNext());
            Class<T[]> type = item.getClass();
            return this.concatenatePages(type, pages, totalSize);
        }
        catch (GHException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Nonnull
    public T[] toArray() throws IOException {
        return this.toArray((PagedIterator<T>)this.iterator());
    }

    @Nonnull
    public List<T> toList() throws IOException {
        return Collections.unmodifiableList(Arrays.asList(this.toArray()));
    }

    @Nonnull
    public Set<T> toSet() throws IOException {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(Arrays.asList(this.toArray())));
    }

    @Nonnull
    private T[] concatenatePages(Class<T[]> type, List<T[]> pages, int totalLength) {
        T[] result = type.cast(Array.newInstance(type.getComponentType(), totalLength));
        int position = 0;
        for (T[] page : pages) {
            int pageLength = Array.getLength(page);
            System.arraycopy(page, 0, result, position, pageLength);
            position += pageLength;
        }
        return result;
    }
}

