/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.authorization;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.CheckForNull;
import org.kohsuke.github.authorization.AuthorizationProvider;
import org.kohsuke.github.authorization.UserAuthorizationProvider;

public class ImmutableAuthorizationProvider
implements AuthorizationProvider {
    private final String authorization;

    public ImmutableAuthorizationProvider(String authorization) {
        this.authorization = authorization;
    }

    public static AuthorizationProvider fromOauthToken(String oauthAccessToken) {
        return new UserProvider(String.format("token %s", oauthAccessToken));
    }

    public static AuthorizationProvider fromOauthToken(String oauthAccessToken, String login) {
        return new UserProvider(String.format("token %s", oauthAccessToken), login);
    }

    public static AuthorizationProvider fromAppInstallationToken(String appInstallationToken) {
        return ImmutableAuthorizationProvider.fromOauthToken(appInstallationToken, "");
    }

    public static AuthorizationProvider fromJwtToken(String jwtToken) {
        return new ImmutableAuthorizationProvider(String.format("Bearer %s", jwtToken));
    }

    @Deprecated
    public static AuthorizationProvider fromLoginAndPassword(String login, String password) {
        try {
            String authorization = String.format("%s:%s", login, password);
            String charsetName = StandardCharsets.UTF_8.name();
            String b64encoded = Base64.getEncoder().encodeToString(authorization.getBytes(charsetName));
            String encodedAuthorization = String.format("Basic %s", b64encoded);
            return new UserProvider(encodedAuthorization, login);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Could not generate encoded authorization", e);
        }
    }

    @Override
    public String getEncodedAuthorization() {
        return this.authorization;
    }

    private static class UserProvider
    extends ImmutableAuthorizationProvider
    implements UserAuthorizationProvider {
        private final String login;

        UserProvider(String authorization) {
            this(authorization, null);
        }

        UserProvider(String authorization, String login) {
            super(authorization);
            this.login = login;
        }

        @Override
        @CheckForNull
        public String getLogin() {
            return this.login;
        }
    }
}

