/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHContentUpdateResponse;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public final class GHContentBuilder {
    private final GHRepository repo;
    private final Requester req;
    private String path;

    GHContentBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = (Requester)repo.root().createRequest().method("PUT");
    }

    public GHContentBuilder path(String path) {
        this.path = path;
        this.req.with("path", path);
        return this;
    }

    public GHContentBuilder branch(String branch) {
        this.req.with("branch", branch);
        return this;
    }

    public GHContentBuilder sha(String sha) {
        this.req.with("sha", sha);
        return this;
    }

    public GHContentBuilder content(byte[] content) {
        this.req.with("content", Base64.getEncoder().encodeToString(content));
        return this;
    }

    public GHContentBuilder content(String content) {
        return this.content(content.getBytes(StandardCharsets.UTF_8));
    }

    public GHContentBuilder message(String commitMessage) {
        this.req.with("message", commitMessage);
        return this;
    }

    public GHContentUpdateResponse commit() throws IOException {
        GHContentUpdateResponse response = ((Requester)this.req.withUrlPath(GHContent.getApiRoute(this.repo, this.path), new String[0])).fetch(GHContentUpdateResponse.class);
        response.getContent().wrap(this.repo);
        response.getCommit().wrapUp(this.repo);
        return response;
    }
}

