/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.ServiceDownException;
import org.kohsuke.github.connector.GitHubConnectorResponse;

abstract class GitHubConnectorResponseErrorHandler {
    public static final int TOO_MANY_REQUESTS = 429;
    static GitHubConnectorResponseErrorHandler STATUS_HTTP_BAD_REQUEST_OR_GREATER = new GitHubConnectorResponseErrorHandler(){
        private static final String CONTENT_TYPE = "Content-type";
        private static final String TEXT_HTML = "text/html";
        private static final String UNICORN_TITLE = "<title>Unicorn!";

        @Override
        public boolean isError(@NotNull GitHubConnectorResponse connectorResponse) throws IOException {
            return connectorResponse.statusCode() >= 400;
        }

        @Override
        public void onError(@NotNull GitHubConnectorResponse connectorResponse) throws IOException {
            if (connectorResponse.statusCode() == 404) {
                throw new FileNotFoundException(connectorResponse.request().url().toString());
            }
            if (this.isServiceDown(connectorResponse)) {
                throw new ServiceDownException(connectorResponse);
            }
            throw new HttpException(connectorResponse);
        }

        private boolean isServiceDown(GitHubConnectorResponse connectorResponse) throws IOException {
            if (connectorResponse.statusCode() < 500) {
                return false;
            }
            String contentTypeHeader = connectorResponse.header(CONTENT_TYPE);
            if (contentTypeHeader != null && contentTypeHeader.contains(TEXT_HTML)) {
                try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(connectorResponse.bodyStream(), StandardCharsets.UTF_8));){
                    String line;
                    for (int hardLineCap = 25; hardLineCap > 0 && (line = bufReader.readLine()) != null; --hardLineCap) {
                        if (!line.trim().startsWith(UNICORN_TITLE)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            return false;
        }
    };

    GitHubConnectorResponseErrorHandler() {
    }

    abstract boolean isError(@Nonnull GitHubConnectorResponse var1) throws IOException;

    public abstract void onError(@Nonnull GitHubConnectorResponse var1) throws IOException;

    static void sleep(long waitMillis) throws IOException {
        try {
            Thread.sleep(waitMillis);
        }
        catch (InterruptedException ex) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(ex);
        }
    }

    static long parseWaitTime(String waitHeader, String dateHeader, long defaultMillis, long minimumMillis) {
        if (waitHeader == null) {
            return defaultMillis;
        }
        try {
            return Math.max(minimumMillis, Duration.ofSeconds(Long.parseLong(waitHeader)).toMillis());
        }
        catch (NumberFormatException nfe) {
            String dateField = dateHeader;
            ZonedDateTime now = dateField != null ? ZonedDateTime.parse(dateField, DateTimeFormatter.RFC_1123_DATE_TIME) : ZonedDateTime.now();
            ZonedDateTime zdt = ZonedDateTime.parse(waitHeader, DateTimeFormatter.RFC_1123_DATE_TIME);
            return Math.max(minimumMillis, ChronoUnit.MILLIS.between(now, zdt));
        }
    }
}

