/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.api.utils;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.io.MemoryFile;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.common.api.model.GeneratedClassResource;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.common.api.model.GeneratedRedirectResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.api.utils.CollectionUtils;
import org.kie.efesto.common.api.utils.FileUtils;
import org.kie.efesto.common.api.utils.JSONUtils;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratedResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)GeneratedResourceUtils.class.getName());

    private GeneratedResourceUtils() {
    }

    public static boolean isPresentExecutableOrRedirect(FRI fri, String modelType) {
        return Stream.of(GeneratedResourceUtils.getGeneratedExecutableResource(fri, modelType), GeneratedResourceUtils.getGeneratedRedirectResource(fri, modelType)).anyMatch(Optional::isPresent);
    }

    public static Optional<GeneratedExecutableResource> getGeneratedExecutableResource(FRI fri, String modelType) {
        return GeneratedResourceUtils.getIndexFile(modelType).flatMap(indexFile -> GeneratedResourceUtils.getGeneratedExecutableResource(fri, indexFile));
    }

    public static Optional<GeneratedExecutableResource> getGeneratedExecutableResource(FRI fri, IndexFile indexFile) {
        Collection<GeneratedExecutableResource> allExecutableResources = GeneratedResourceUtils.getAllGeneratedExecutableResources(indexFile);
        return CollectionUtils.findAtMostOne(allExecutableResources, generatedResource -> generatedResource.getFri().equals((Object)fri), (s1, s2) -> new KieRuntimeServiceException("Found more than one Executable Resource (" + s1 + " and " + s2 + ") for " + fri));
    }

    public static Optional<GeneratedRedirectResource> getGeneratedRedirectResource(FRI fri, String modelType) {
        return GeneratedResourceUtils.getIndexFile(modelType).flatMap(indexFile -> {
            try {
                GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                return generatedResources.stream().filter(generatedResource -> generatedResource instanceof GeneratedRedirectResource && ((GeneratedRedirectResource)generatedResource).getFri().equals((Object)fri)).findFirst().map(GeneratedRedirectResource.class::cast);
            }
            catch (Exception e) {
                logger.error("Failed to read GeneratedResources from {}.", (Object)indexFile.getName(), (Object)e);
                return Optional.empty();
            }
        });
    }

    public static Collection<GeneratedExecutableResource> getAllGeneratedExecutableResources(String modelType) {
        return GeneratedResourceUtils.getIndexFile(modelType).map(GeneratedResourceUtils::getAllGeneratedExecutableResources).orElse(Collections.emptySet());
    }

    public static Collection<GeneratedExecutableResource> getAllGeneratedExecutableResources(IndexFile indexFile) {
        logger.debug("getAllGeneratedExecutableResources {}", (Object)indexFile);
        HashSet<GeneratedExecutableResource> toReturn = new HashSet<GeneratedExecutableResource>();
        try {
            GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
            logger.debug("generatedResources {}", (Object)generatedResources);
            toReturn.addAll(generatedResources.stream().filter(GeneratedExecutableResource.class::isInstance).map(GeneratedExecutableResource.class::cast).collect(Collectors.toSet()));
        }
        catch (Exception e) {
            logger.error("Failed to read GeneratedClassResource from {}.", (Object)indexFile.getName(), (Object)e);
        }
        return toReturn;
    }

    public static Collection<GeneratedClassResource> getAllGeneratedClassResources(String modelType) {
        HashSet<GeneratedClassResource> toReturn = new HashSet<GeneratedClassResource>();
        GeneratedResourceUtils.getIndexFile(modelType).ifPresent(indexFile -> {
            try {
                GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                toReturn.addAll(generatedResources.stream().filter(GeneratedClassResource.class::isInstance).map(GeneratedClassResource.class::cast).collect(Collectors.toSet()));
            }
            catch (Exception e) {
                logger.debug("Failed to read GeneratedClassResource from {}.", (Object)indexFile.getName(), (Object)e);
            }
        });
        return toReturn;
    }

    public static Optional<IndexFile> getIndexFile(String modelType) {
        logger.debug("getIndexFile {}", (Object)modelType);
        IndexFile toSearch = new IndexFile(modelType);
        Optional retrieved = FileUtils.getFileFromFileName((String)toSearch.getName());
        if (retrieved.isPresent()) {
            File actualFile = (File)retrieved.get();
            IndexFile toReturn = actualFile instanceof MemoryFile ? new IndexFile((MemoryFile)actualFile) : new IndexFile(actualFile);
            logger.debug("returning {}", (Object)toReturn);
            return Optional.of(toReturn);
        }
        logger.debug("returning empty");
        return Optional.empty();
    }
}

