/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.compilationmanager.api.model;

import java.nio.file.Path;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.listener.EfestoListener;
import org.kie.efesto.common.api.model.EfestoContext;
import org.kie.efesto.compilationmanager.api.exceptions.EfestoCompilationManagerException;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContextImpl;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;
import org.kie.memorycompiler.KieMemoryCompiler;

public interface EfestoCompilationContext<T extends EfestoListener>
extends EfestoContext<T> {
    public static EfestoCompilationContext buildWithParentClassLoader(ClassLoader parentClassLoader) {
        return new EfestoCompilationContextImpl(new KieMemoryCompiler.MemoryCompilerClassLoader(parentClassLoader));
    }

    public static EfestoCompilationContext buildFromContext(EfestoCompilationContextImpl original, Class<? extends EfestoCompilationContext> toInstantiate) {
        try {
            EfestoCompilationContext toReturn = toInstantiate.getDeclaredConstructor(KieMemoryCompiler.MemoryCompilerClassLoader.class).newInstance(original.memoryCompilerClassLoader);
            toReturn.getGeneratedResourcesMap().putAll(original.getGeneratedResourcesMap());
            return toReturn;
        }
        catch (Exception e) {
            throw new EfestoCompilationManagerException("Failed to instantiate " + toInstantiate.getName(), e);
        }
    }

    public Map<String, byte[]> compileClasses(Map<String, String> var1);

    public void loadClasses(Map<String, byte[]> var1);

    public ServiceLoader<KieCompilerService> getKieCompilerServiceLoader();

    public byte[] getCode(String var1);

    default public Map<String, IndexFile> createIndexFiles(Path targetDirectory) {
        throw new UnsupportedOperationException();
    }
}

