/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.compilationmanager.api.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.CompilationManager;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPIUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)SPIUtils.class.getName());
    private static final ServiceLoader<CompilationManager> compilationManagerLoader = ServiceLoader.load(CompilationManager.class);
    private static final ServiceLoader<KieCompilerService> kieCompilerServiceLoader = ServiceLoader.load(KieCompilerService.class);

    private SPIUtils() {
    }

    public static Optional<KieCompilerService> getKieCompilerService(EfestoResource resource, boolean refresh) {
        logger.debug("getKieCompilerService {} {}", (Object)resource, (Object)refresh);
        List<KieCompilerService> retrieved = SPIUtils.getKieCompilerServices(refresh);
        return retrieved.stream().filter(service -> service.canManageResource(resource)).findFirst();
    }

    public static List<KieCompilerService> getKieCompilerServices(boolean refresh) {
        logger.debug("getKieCompilerServices {}", (Object)refresh);
        ArrayList<KieCompilerService> toReturn = new ArrayList<KieCompilerService>();
        Iterator<KieCompilerService> services = SPIUtils.getServices(refresh);
        services.forEachRemaining(toReturn::add);
        logger.debug("toReturn {} {}", toReturn, (Object)toReturn.size());
        if (logger.isTraceEnabled()) {
            toReturn.forEach(provider -> logger.trace("{}", provider));
        }
        return toReturn;
    }

    public static Optional<CompilationManager> getCompilationManager(boolean refresh) {
        logger.debug("getCompilationManager {}", (Object)refresh);
        ArrayList toReturn = new ArrayList();
        Iterator<CompilationManager> managers = SPIUtils.getManagers(refresh);
        managers.forEachRemaining(toReturn::add);
        return toReturn.stream().findFirst();
    }

    private static Iterator<KieCompilerService> getServices(boolean refresh) {
        if (refresh) {
            kieCompilerServiceLoader.reload();
        }
        return kieCompilerServiceLoader.iterator();
    }

    private static Iterator<CompilationManager> getManagers(boolean refresh) {
        if (refresh) {
            compilationManagerLoader.reload();
        }
        return compilationManagerLoader.iterator();
    }
}

