/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth.device;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.PkceGenerator;

public class DeviceTokenRequest
extends AbstractHttpPostRequest<DeviceTokenRequest, AccessTokenResponse> {
    private final String deviceCode;

    DeviceTokenRequest(String deviceCode, AbstractOAuthClient<?> client) {
        super(client);
        this.deviceCode = deviceCode;
    }

    public DeviceTokenRequest codeVerifier(PkceGenerator pkceGenerator) {
        if (pkceGenerator != null) {
            this.codeVerifier(pkceGenerator.getCodeVerifier());
        }
        return this;
    }

    public DeviceTokenRequest codeVerifier(String codeVerifier) {
        this.parameter("code_verifier", codeVerifier);
        return this;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getToken();
    }

    @Override
    protected void initRequest() {
        this.parameter("grant_type", "urn:ietf:params:oauth:grant-type:device_code");
        this.parameter("device_code", this.deviceCode);
    }

    @Override
    protected AccessTokenResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new AccessTokenResponse(response);
    }
}

