/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.TokenRevocationResponse;

public class TokenRevocationRequest
extends AbstractHttpPostRequest<TokenRevocationRequest, TokenRevocationResponse> {
    private final String token;
    private String tokenTypeHint;

    TokenRevocationRequest(String token, AbstractOAuthClient<?> client) {
        super(client);
        this.token = token;
    }

    public TokenRevocationRequest tokenTypeHint(String tokenTypeHint) {
        this.tokenTypeHint = tokenTypeHint;
        return this;
    }

    public TokenRevocationRequest accessToken() {
        this.tokenTypeHint = "access_token";
        return this;
    }

    public TokenRevocationRequest refreshToken() {
        this.tokenTypeHint = "refresh_token";
        return this;
    }

    public TokenRevocationRequest dpopProof(String dpopProof) {
        this.header("DPoP", dpopProof);
        return this;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getRevocation();
    }

    @Override
    protected void initRequest() {
        this.parameter("token", this.token);
        this.parameter("token_type_hint", this.tokenTypeHint);
    }

    @Override
    protected TokenRevocationResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new TokenRevocationResponse(response);
    }
}

