/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import org.keycloak.protocol.oidc.utils.PkceUtils;

public class PkceGenerator {
    private final String codeVerifier;
    private final String codeChallenge;
    private final String codeChallengeMethod;

    public static PkceGenerator s256() {
        String codeVerifier = PkceUtils.generateCodeVerifier();
        String codeChallenge = PkceUtils.generateS256CodeChallenge((String)codeVerifier);
        String codeChallengeMethod = "S256";
        return new PkceGenerator(codeVerifier, codeChallenge, codeChallengeMethod);
    }

    public static PkceGenerator plain() {
        String codeVerifier = PkceUtils.generateCodeVerifier();
        String codeChallengeMethod = "plain";
        return new PkceGenerator(codeVerifier, codeVerifier, codeChallengeMethod);
    }

    private PkceGenerator(String codeVerifier, String codeChallenge, String codeChallengeMethod) {
        this.codeVerifier = codeVerifier;
        this.codeChallenge = codeChallenge;
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }
}

