/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

public class PasswordGrantRequest
extends AbstractHttpPostRequest<PasswordGrantRequest, AccessTokenResponse> {
    private final String username;
    private final String password;
    private String otp;

    PasswordGrantRequest(String username, String password, AbstractOAuthClient<?> client) {
        super(client);
        this.username = username;
        this.password = password;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getToken();
    }

    public PasswordGrantRequest otp(String otp) {
        this.otp = otp;
        return this;
    }

    public PasswordGrantRequest dpopProof(String dpopProof) {
        this.header("DPoP", dpopProof);
        return this;
    }

    public PasswordGrantRequest param(String name, String value) {
        this.parameter(name, value);
        return this;
    }

    @Override
    protected void initRequest() {
        this.parameter("grant_type", "password");
        this.parameter("username", this.username);
        this.parameter("password", this.password);
        this.parameter("otp", this.otp);
        this.scope();
    }

    @Override
    protected AccessTokenResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new AccessTokenResponse(response);
    }
}

