/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpGetRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

public class FetchExternalIdpTokenRequest
extends AbstractHttpGetRequest<AccessTokenResponse> {
    private final String providerAlias;
    private final String accessToken;

    FetchExternalIdpTokenRequest(String providerAlias, String accessToken, AbstractOAuthClient<?> client) {
        super(client);
        this.providerAlias = providerAlias;
        this.accessToken = accessToken;
    }

    @Override
    protected String getEndpoint() {
        return UriBuilder.fromUri((String)this.client.baseUrl).path("/realms/{realm-name}/broker/{provider_alias}/token").buildFromMap(Map.of("realm-name", this.client.config.getRealm(), "provider_alias", this.providerAlias)).toString();
    }

    @Override
    protected void initRequest() {
        this.header("Authorization", "Bearer " + this.accessToken);
        if (this.client.config.getOrigin() != null) {
            this.header("Origin", this.client.config.getOrigin());
        }
    }

    @Override
    protected AccessTokenResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new AccessTokenResponse(response){

            @Override
            protected void parseError() throws IOException {
                ObjectNode json = this.asJson(ObjectNode.class);
                this.setError(json.has("errorMessage") ? json.get("errorMessage").asText() : null);
            }
        };
    }
}

