/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.representations.idm.IdentityProviderRepresentation;

public class IdentityProviderBuilder {
    private IdentityProviderRepresentation rep = new IdentityProviderRepresentation();

    public static IdentityProviderBuilder create() {
        return new IdentityProviderBuilder();
    }

    private IdentityProviderBuilder() {
        this.rep.setEnabled(true);
    }

    public IdentityProviderBuilder alias(String alias) {
        this.rep.setAlias(alias);
        return this;
    }

    public IdentityProviderBuilder providerId(String providerId) {
        this.rep.setProviderId(providerId);
        return this;
    }

    public IdentityProviderBuilder displayName(String displayName) {
        this.rep.setDisplayName(displayName);
        return this;
    }

    public IdentityProviderBuilder hideOnLoginPage() {
        this.rep.setHideOnLogin(true);
        return this;
    }

    public IdentityProviderBuilder setAttribute(String name, String value) {
        this.config().put(name, value);
        return this;
    }

    public IdentityProviderBuilder removeAttribute(String name) {
        this.config().put(name, null);
        return this;
    }

    private Map<String, String> config() {
        if (this.rep.getConfig() == null) {
            this.rep.setConfig(new HashMap());
        }
        return this.rep.getConfig();
    }

    public IdentityProviderRepresentation build() {
        return this.rep;
    }
}

