/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.JwksResponse;

public class JwksRequest {
    private final AbstractOAuthClient<?> client;

    JwksRequest(AbstractOAuthClient<?> client) {
        this.client = client;
    }

    public JSONWebKeySet send() throws IOException {
        HttpGet get = new HttpGet(this.client.getEndpoints().getJwks());
        get.addHeader("Accept", "application/json");
        JwksResponse response = new JwksResponse(this.client.httpClient().get().execute((HttpUriRequest)get));
        if (response.isSuccess()) {
            return response.getJwks();
        }
        throw new IOException("Failed to fetch keys: " + response.getStatusCode());
    }
}

