/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.PkceGenerator;

public class AccessTokenRequest
extends AbstractHttpPostRequest<AccessTokenRequest, AccessTokenResponse> {
    private final String code;

    AccessTokenRequest(String code, AbstractOAuthClient<?> client) {
        super(client);
        this.code = code;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getToken();
    }

    public AccessTokenRequest signedJwt(String signedJwt) {
        this.parameter("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        this.parameter("client_assertion", signedJwt);
        return this;
    }

    public AccessTokenRequest codeVerifier(PkceGenerator pkceGenerator) {
        if (pkceGenerator != null) {
            this.codeVerifier(pkceGenerator.getCodeVerifier());
        }
        return this;
    }

    public AccessTokenRequest codeVerifier(String codeVerifier) {
        this.parameter("code_verifier", codeVerifier);
        return this;
    }

    public AccessTokenRequest dpopProof(String dpopProof) {
        this.header("DPoP", dpopProof);
        return this;
    }

    public AccessTokenRequest param(String name, String value) {
        this.parameter(name, value);
        return this;
    }

    @Override
    protected void initRequest() {
        this.parameter("grant_type", "authorization_code");
        this.parameter("code", this.code);
        this.parameter("redirect_uri", this.client.getRedirectUri());
    }

    @Override
    protected AccessTokenResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new AccessTokenResponse(response);
    }
}

