/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.InputStream;
import java.net.URI;
import java.security.PublicKey;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.ClientConnection;
import org.keycloak.VerificationException;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.NameIDPolicyType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.protocol.saml.SAML2LogoutResponseBuilder;
import org.keycloak.protocol.saml.SAMLRequestParser;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.HttpAuthenticationManager;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.util.StreamUtil;

public class SamlService {
    protected static final Logger logger = Logger.getLogger(SamlService.class);
    protected RealmModel realm;
    private EventBuilder event;
    protected AuthenticationManager authManager;
    @Context
    protected Providers providers;
    @Context
    protected SecurityContext securityContext;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;

    public SamlService(RealmModel realm, EventBuilder event, AuthenticationManager authManager) {
        this.realm = realm;
        this.event = event;
        this.authManager = authManager;
    }

    @GET
    public Response redirectBinding(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState) {
        logger.debug((Object)"SAML GET");
        return new RedirectBindingProtocol().execute(samlRequest, samlResponse, relayState);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBinding(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState) {
        logger.debug((Object)"SAML POST");
        return new PostBindingProtocol().execute(samlRequest, samlResponse, relayState);
    }

    @GET
    @Path(value="descriptor")
    @Produces(value={"application/xml"})
    public String getDescriptor() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/idp-metadata-template.xml");
        String template = StreamUtil.readString((InputStream)is);
        template = template.replace("${idp.entityID}", RealmsResource.realmBaseUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName()}).toString());
        template = template.replace("${idp.sso.HTTP-POST}", RealmsResource.protocolUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName(), "saml"}).toString());
        template = template.replace("${idp.sso.HTTP-Redirect}", RealmsResource.protocolUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName(), "saml"}).toString());
        template = template.replace("${idp.sls.HTTP-POST}", RealmsResource.protocolUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName(), "saml"}).toString());
        template = template.replace("${idp.signing.certificate}", this.realm.getCertificatePem());
        return template;
    }

    protected class RedirectBindingProtocol
    extends BindingProtocol {
        protected RedirectBindingProtocol() {
        }

        @Override
        protected void verifySignature(SAMLDocumentHolder documentHolder, ClientModel client) throws VerificationException {
            if (!"true".equals(client.getAttribute("saml.client.signature"))) {
                return;
            }
            PublicKey publicKey = SamlProtocolUtils.getSignatureValidationKey(client);
            SamlProtocolUtils.verifyRedirectSignature(publicKey, SamlService.this.uriInfo);
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestRedirectBinding(samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseRequestRedirectBinding(response);
        }

        @Override
        protected String getBindingType() {
            return "get";
        }

        public Response execute(String samlRequest, String samlResponse, String relayState) {
            Response response = this.basicChecks(samlRequest, samlResponse);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState);
        }
    }

    protected class PostBindingProtocol
    extends BindingProtocol {
        protected PostBindingProtocol() {
        }

        @Override
        protected void verifySignature(SAMLDocumentHolder documentHolder, ClientModel client) throws VerificationException {
            SamlProtocolUtils.verifyDocumentSignature(client, documentHolder.getSamlDocument());
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestPostBinding(samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseResponsePostBinding(response);
        }

        @Override
        protected String getBindingType() {
            return "post";
        }

        public Response execute(String samlRequest, String samlResponse, String relayState) {
            Response response = this.basicChecks(samlRequest, samlResponse);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState);
        }
    }

    public abstract class BindingProtocol {
        protected Response basicChecks(String samlRequest, String samlResponse) {
            if (!this.checkSsl()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("ssl_required");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"httpsRequiredMessage", (Object[])new Object[0]);
            }
            if (!SamlService.this.realm.isEnabled()) {
                SamlService.this.event.event(EventType.LOGIN_ERROR);
                SamlService.this.event.error("realm_disabled");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"realmNotEnabledMessage", (Object[])new Object[0]);
            }
            if (samlRequest == null && samlResponse == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_token");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            return null;
        }

        protected Response handleSamlResponse(String samlResponse, String relayState) {
            SamlService.this.event.event(EventType.LOGOUT);
            SAMLDocumentHolder holder = this.extractResponseDocument(samlResponse);
            StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
            if (!SamlService.this.uriInfo.getAbsolutePath().toString().equals(statusResponse.getDestination())) {
                SamlService.this.event.error("invalid_logout_response");
                SamlService.this.event.detail("reason", "invalid_destination");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            AuthenticationManager cfr_ignored_0 = SamlService.this.authManager;
            AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (ClientConnection)SamlService.this.clientConnection, (HttpHeaders)SamlService.this.headers, (boolean)false);
            if (authResult == null) {
                logger.warn((Object)"Unknown saml response.");
                SamlService.this.event.event(EventType.LOGOUT);
                SamlService.this.event.error("invalid_token");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            UserSessionModel userSession = authResult.getSession();
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.warn((Object)"Unknown saml response.");
                logger.warn((Object)"UserSession is not tagged as logging out.");
                SamlService.this.event.event(EventType.LOGOUT);
                SamlService.this.event.error("invalid_logout_response");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            logger.debug((Object)"logout response");
            AuthenticationManager cfr_ignored_1 = SamlService.this.authManager;
            Response response = AuthenticationManager.browserLogout((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UserSessionModel)userSession, (UriInfo)SamlService.this.uriInfo, (ClientConnection)SamlService.this.clientConnection, (HttpHeaders)SamlService.this.headers);
            SamlService.this.event.success();
            return response;
        }

        protected Response handleSamlRequest(String samlRequest, String relayState) {
            SAMLDocumentHolder documentHolder = this.extractRequestDocument(samlRequest);
            if (documentHolder == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_token");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            SAML2Object samlObject = documentHolder.getSamlObject();
            RequestAbstractType requestAbstractType = (RequestAbstractType)samlObject;
            String issuer = requestAbstractType.getIssuer().getValue();
            ClientModel client = SamlService.this.realm.getClientByClientId(issuer);
            if (client == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("client_not_found");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"unknownLoginRequesterMessage", (Object[])new Object[0]);
            }
            if (!client.isEnabled()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("client_disabled");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"loginRequesterNotEnabledMessage", (Object[])new Object[0]);
            }
            if (client instanceof ClientModel && client.isBearerOnly()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("not_allowed");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"bearerOnlyMessage", (Object[])new Object[0]);
            }
            if (client.isDirectGrantsOnly()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("not_allowed");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"directGrantsOnlyMessage", (Object[])new Object[0]);
            }
            SamlService.this.session.getContext().setClient(client);
            try {
                this.verifySignature(documentHolder, client);
            }
            catch (VerificationException e) {
                logger.error((Object)"request validation failed", (Throwable)e);
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_signature");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequesterMessage", (Object[])new Object[0]);
            }
            logger.debug((Object)"verified request");
            if (samlObject instanceof AuthnRequestType) {
                logger.debug((Object)"** login request");
                SamlService.this.event.event(EventType.LOGIN);
                AuthnRequestType authn = (AuthnRequestType)samlObject;
                return this.loginRequest(relayState, authn, client);
            }
            if (samlObject instanceof LogoutRequestType) {
                logger.debug((Object)"** logout request");
                SamlService.this.event.event(EventType.LOGOUT);
                LogoutRequestType logout = (LogoutRequestType)samlObject;
                return this.logoutRequest(logout, client, relayState);
            }
            SamlService.this.event.event(EventType.LOGIN);
            SamlService.this.event.error("invalid_token");
            return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
        }

        protected abstract void verifySignature(SAMLDocumentHolder var1, ClientModel var2) throws VerificationException;

        protected abstract SAMLDocumentHolder extractRequestDocument(String var1);

        protected abstract SAMLDocumentHolder extractResponseDocument(String var1);

        protected Response loginRequest(String relayState, AuthnRequestType requestAbstractType, ClientModel client) {
            String rememberMeUsername;
            Response response;
            if (!SamlService.this.uriInfo.getAbsolutePath().equals(requestAbstractType.getDestination())) {
                SamlService.this.event.error("invalid_authn_request");
                SamlService.this.event.detail("reason", "invalid_destination");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            String bindingType = this.getBindingType(requestAbstractType);
            if ("true".equals(client.getAttribute("saml.force.post.binding"))) {
                bindingType = "post";
            }
            String redirect = null;
            URI redirectUri = requestAbstractType.getAssertionConsumerServiceURL();
            if (redirectUri != null && !"null".equals(redirectUri)) {
                redirect = RedirectUtils.verifyRedirectUri((UriInfo)SamlService.this.uriInfo, (String)redirectUri.toString(), (RealmModel)SamlService.this.realm, (ClientModel)client);
            } else {
                redirect = bindingType.equals("post") ? client.getAttribute("saml_assertion_consumer_url_post") : client.getAttribute("saml_assertion_consumer_url_redirect");
                if (redirect == null && client instanceof ClientModel) {
                    redirect = client.getManagementUrl();
                }
            }
            if (redirect == null) {
                SamlService.this.event.error("invalid_redirect_uri");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRedirectUriMessage", (Object[])new Object[0]);
            }
            ClientSessionModel clientSession = SamlService.this.session.sessions().createClientSession(SamlService.this.realm, client);
            clientSession.setAuthMethod("saml");
            clientSession.setRedirectUri(redirect);
            clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE);
            clientSession.setNote("action_key", KeycloakModelUtils.generateCodeSecret());
            clientSession.setNote("saml_binding", bindingType);
            clientSession.setNote("RelayState", relayState);
            clientSession.setNote("SAML_REQUEST_ID", requestAbstractType.getID());
            NameIDPolicyType nameIdPolicy = requestAbstractType.getNameIDPolicy();
            if (nameIdPolicy != null && !SamlProtocol.forceNameIdFormat(client)) {
                String nameIdFormat = nameIdPolicy.getFormat().toString();
                if (this.isSupportedNameIdFormat(nameIdFormat)) {
                    clientSession.setNote("NAMEID_FORMAT", nameIdFormat);
                } else {
                    SamlService.this.event.error("invalid_authn_request");
                    SamlService.this.event.detail("reason", "unsupported_nameid_format");
                    return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"unsupportedNameIdFormatMessage", (Object[])new Object[0]);
                }
            }
            if ((response = SamlService.this.authManager.checkNonFormAuthentication(SamlService.this.session, clientSession, SamlService.this.realm, SamlService.this.uriInfo, SamlService.this.request, SamlService.this.clientConnection, SamlService.this.headers, SamlService.this.event)) != null) {
                return response;
            }
            HttpAuthenticationManager httpAuthManager = new HttpAuthenticationManager(SamlService.this.session, clientSession, SamlService.this.realm, SamlService.this.uriInfo, SamlService.this.request, SamlService.this.clientConnection, SamlService.this.event);
            HttpAuthenticationManager.HttpAuthOutput httpAuthOutput = httpAuthManager.spnegoAuthenticate(SamlService.this.headers);
            if (httpAuthOutput.getResponse() != null) {
                return httpAuthOutput.getResponse();
            }
            LoginFormsProvider forms = ((LoginFormsProvider)SamlService.this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(new ClientSessionCode(SamlService.this.realm, clientSession).getCode());
            if (httpAuthOutput.getChallenge() != null) {
                httpAuthOutput.getChallenge().sendChallenge(forms);
            }
            if ((rememberMeUsername = AuthenticationManager.getRememberMeUsername((RealmModel)SamlService.this.realm, (HttpHeaders)SamlService.this.headers)) != null) {
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"username", (Object)rememberMeUsername);
                formData.add((Object)"rememberMe", (Object)"on");
                forms.setFormData((MultivaluedMap)formData);
            }
            return forms.createLogin();
        }

        private String getBindingType(AuthnRequestType requestAbstractType) {
            URI requestedProtocolBinding = requestAbstractType.getProtocolBinding();
            if (requestedProtocolBinding != null) {
                if (JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get().equals(requestedProtocolBinding.toString())) {
                    return "post";
                }
                return "get";
            }
            return this.getBindingType();
        }

        private boolean isSupportedNameIdFormat(String nameIdFormat) {
            return nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get());
        }

        protected abstract String getBindingType();

        protected Response logoutRequest(LogoutRequestType logoutRequest, ClientModel client, String relayState) {
            if (!SamlService.this.uriInfo.getAbsolutePath().equals(logoutRequest.getDestination())) {
                SamlService.this.event.error("invalid_logout_request");
                SamlService.this.event.detail("reason", "invalid_destination");
                return ErrorPage.error((KeycloakSession)SamlService.this.session, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            AuthenticationManager cfr_ignored_0 = SamlService.this.authManager;
            AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (ClientConnection)SamlService.this.clientConnection, (HttpHeaders)SamlService.this.headers, (boolean)false);
            if (authResult != null) {
                String logoutBinding = this.getBindingType();
                if ("true".equals(client.getAttribute("saml.force.post.binding"))) {
                    logoutBinding = "post";
                }
                String bindingUri = SamlProtocol.getLogoutServiceUrl(SamlService.this.uriInfo, client, logoutBinding);
                UserSessionModel userSession = authResult.getSession();
                userSession.setNote("SAML_LOGOUT_BINDING_URI", bindingUri);
                if (SamlProtocol.requiresRealmSignature(client)) {
                    userSession.setNote("saml.logout.signature.algorithm", SamlProtocol.getSignatureAlgorithm(client).toString());
                }
                if (relayState != null) {
                    userSession.setNote("SAML_LOGOUT_RELAY_STATE", relayState);
                }
                userSession.setNote("SAML_LOGOUT_REQUEST_ID", logoutRequest.getID());
                userSession.setNote("saml.logout.binding", logoutBinding);
                userSession.setNote("KEYCLOAK_LOGOUT_PROTOCOL", "saml");
                for (ClientSessionModel clientSession : userSession.getClientSessions()) {
                    if (!clientSession.getClient().getId().equals(client.getId())) continue;
                    clientSession.setAction(ClientSessionModel.Action.LOGGED_OUT);
                }
                logger.debug((Object)"browser Logout");
                AuthenticationManager cfr_ignored_1 = SamlService.this.authManager;
                return AuthenticationManager.browserLogout((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UserSessionModel)userSession, (UriInfo)SamlService.this.uriInfo, (ClientConnection)SamlService.this.clientConnection, (HttpHeaders)SamlService.this.headers);
            }
            if (logoutRequest.getSessionIndex() != null) {
                for (String sessionIndex : logoutRequest.getSessionIndex()) {
                    ClientSessionModel clientSession = SamlService.this.session.sessions().getClientSession(SamlService.this.realm, sessionIndex);
                    if (clientSession == null) continue;
                    if (clientSession.getClient().getClientId().equals(client.getClientId())) {
                        clientSession.setAction(ClientSessionModel.Action.LOGGED_OUT);
                    }
                    UserSessionModel userSession = clientSession.getUserSession();
                    try {
                        AuthenticationManager cfr_ignored_2 = SamlService.this.authManager;
                        AuthenticationManager.backchannelLogout((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UserSessionModel)userSession, (UriInfo)SamlService.this.uriInfo, (ClientConnection)SamlService.this.clientConnection, (HttpHeaders)SamlService.this.headers, (boolean)true);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failure with backchannel logout", (Throwable)e);
                    }
                }
            }
            String logoutBinding = this.getBindingType();
            String logoutBindingUri = SamlProtocol.getLogoutServiceUrl(SamlService.this.uriInfo, client, logoutBinding);
            String logoutRelayState = relayState;
            SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
            builder.logoutRequestID(logoutRequest.getID());
            builder.destination(logoutBindingUri);
            builder.issuer(RealmsResource.realmBaseUrl((UriInfo)SamlService.this.uriInfo).build(new Object[]{SamlService.this.realm.getName()}).toString());
            builder.relayState(logoutRelayState);
            if (SamlProtocol.requiresRealmSignature(client)) {
                SignatureAlgorithm algorithm = SamlProtocol.getSignatureAlgorithm(client);
                ((SAML2LogoutResponseBuilder)((SAML2LogoutResponseBuilder)builder.signatureAlgorithm(algorithm)).signWith(SamlService.this.realm.getPrivateKey(), SamlService.this.realm.getPublicKey(), SamlService.this.realm.getCertificate())).signDocument();
            }
            try {
                if ("post".equals(logoutBinding)) {
                    return builder.postBinding().response(logoutBindingUri);
                }
                return builder.redirectBinding().response(logoutBindingUri);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean checkSsl() {
            if (SamlService.this.uriInfo.getBaseUri().getScheme().equals("https")) {
                return true;
            }
            return !SamlService.this.realm.getSslRequired().isRequired(SamlService.this.clientConnection);
        }
    }
}

