/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.iharder.Base64;
import org.jboss.logging.Logger;
import org.keycloak.enums.SslRequired;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.ClaimRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class RepresentationToModel {
    private static Logger logger = Logger.getLogger(RepresentationToModel.class);

    public static void importRealm(KeycloakSession session, RealmRepresentation rep, RealmModel newRealm) {
        Map<String, ApplicationModel> appMap;
        newRealm.setName(rep.getRealm());
        if (rep.isEnabled() != null) {
            newRealm.setEnabled(rep.isEnabled());
        }
        if (rep.isSocial() != null) {
            newRealm.setSocial(rep.isSocial());
        }
        if (rep.isBruteForceProtected() != null) {
            newRealm.setBruteForceProtected(rep.isBruteForceProtected());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            newRealm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            newRealm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            newRealm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            newRealm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            newRealm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds());
        }
        if (rep.getFailureFactor() != null) {
            newRealm.setFailureFactor(rep.getFailureFactor());
        }
        if (rep.getNotBefore() != null) {
            newRealm.setNotBefore(rep.getNotBefore());
        }
        if (rep.getAccessTokenLifespan() != null) {
            newRealm.setAccessTokenLifespan(rep.getAccessTokenLifespan());
        } else {
            newRealm.setAccessTokenLifespan(300);
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            newRealm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout());
        } else {
            newRealm.setSsoSessionIdleTimeout(600);
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            newRealm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan());
        } else {
            newRealm.setSsoSessionMaxLifespan(36000);
        }
        if (rep.getAccessCodeLifespan() != null) {
            newRealm.setAccessCodeLifespan(rep.getAccessCodeLifespan());
        } else {
            newRealm.setAccessCodeLifespan(60);
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            newRealm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction());
        } else {
            newRealm.setAccessCodeLifespanUserAction(300);
        }
        if (rep.getSslRequired() != null) {
            newRealm.setSslRequired(SslRequired.valueOf((String)rep.getSslRequired().toUpperCase()));
        }
        if (rep.isPasswordCredentialGrantAllowed() != null) {
            newRealm.setPasswordCredentialGrantAllowed(rep.isPasswordCredentialGrantAllowed());
        }
        if (rep.isRegistrationAllowed() != null) {
            newRealm.setRegistrationAllowed(rep.isRegistrationAllowed());
        }
        if (rep.isRememberMe() != null) {
            newRealm.setRememberMe(rep.isRememberMe());
        }
        if (rep.isVerifyEmail() != null) {
            newRealm.setVerifyEmail(rep.isVerifyEmail());
        }
        if (rep.isResetPasswordAllowed() != null) {
            newRealm.setResetPasswordAllowed(rep.isResetPasswordAllowed());
        }
        if (rep.isUpdateProfileOnInitialSocialLogin() != null) {
            newRealm.setUpdateProfileOnInitialSocialLogin(rep.isUpdateProfileOnInitialSocialLogin());
        }
        if (rep.getPrivateKey() == null || rep.getPublicKey() == null) {
            KeycloakModelUtils.generateRealmKeys(newRealm);
        } else {
            newRealm.setPrivateKeyPem(rep.getPrivateKey());
            newRealm.setPublicKeyPem(rep.getPublicKey());
        }
        if (rep.getLoginTheme() != null) {
            newRealm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            newRealm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            newRealm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            newRealm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.getRequiredCredentials() != null) {
            for (String string : rep.getRequiredCredentials()) {
                RepresentationToModel.addRequiredCredential(newRealm, string);
            }
        } else {
            RepresentationToModel.addRequiredCredential(newRealm, "password");
        }
        if (rep.getPasswordPolicy() != null) {
            newRealm.setPasswordPolicy(new PasswordPolicy(rep.getPasswordPolicy()));
        }
        if (rep.getApplications() != null) {
            appMap = RepresentationToModel.createApplications(rep, newRealm);
        }
        if (rep.getRoles() != null) {
            RoleModel role;
            ApplicationModel app;
            if (rep.getRoles().getRealm() != null) {
                for (RoleRepresentation roleRepresentation : rep.getRoles().getRealm()) {
                    RepresentationToModel.createRole(newRealm, roleRepresentation);
                }
            }
            if (rep.getRoles().getApplication() != null) {
                for (Map.Entry entry : rep.getRoles().getApplication().entrySet()) {
                    app = newRealm.getApplicationByName((String)entry.getKey());
                    if (app == null) {
                        throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                    }
                    for (RoleRepresentation roleRep : (List)entry.getValue()) {
                        role = roleRep.getId() != null ? app.addRole(roleRep.getId(), roleRep.getName()) : app.addRole(roleRep.getName());
                        role.setDescription(roleRep.getDescription());
                    }
                }
            }
            if (rep.getRoles().getRealm() != null) {
                for (RoleRepresentation roleRepresentation : rep.getRoles().getRealm()) {
                    RoleModel role2 = newRealm.getRole(roleRepresentation.getName());
                    RepresentationToModel.addComposites(role2, roleRepresentation, newRealm);
                }
            }
            if (rep.getRoles().getApplication() != null) {
                for (Map.Entry entry : rep.getRoles().getApplication().entrySet()) {
                    app = newRealm.getApplicationByName((String)entry.getKey());
                    if (app == null) {
                        throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                    }
                    for (RoleRepresentation roleRep : (List)entry.getValue()) {
                        role = app.getRole(roleRep.getName());
                        RepresentationToModel.addComposites(role, roleRep, newRealm);
                    }
                }
            }
        }
        if (rep.getDefaultRoles() != null) {
            for (String string : rep.getDefaultRoles()) {
                newRealm.addDefaultRole(string.trim());
            }
        }
        if (rep.getApplications() != null) {
            for (ApplicationRepresentation applicationRepresentation : rep.getApplications()) {
                if (applicationRepresentation.getDefaultRoles() == null) continue;
                ApplicationModel appModel = newRealm.getApplicationByName(applicationRepresentation.getName());
                appModel.updateDefaultRoles(applicationRepresentation.getDefaultRoles());
            }
        }
        if (rep.getOauthClients() != null) {
            RepresentationToModel.createOAuthClients(rep, newRealm);
        }
        appMap = newRealm.getApplicationNameMap();
        if (rep.getApplicationScopeMappings() != null) {
            for (Map.Entry entry : rep.getApplicationScopeMappings().entrySet()) {
                ApplicationModel app = appMap.get(entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find application role mappings for app: " + (String)entry.getKey());
                }
                RepresentationToModel.createApplicationScopeMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getScopeMappings() != null) {
            for (ScopeMappingRepresentation scope : rep.getScopeMappings()) {
                ClientModel client = newRealm.findClient(scope.getClient());
                if (client == null) {
                    throw new RuntimeException("Unknown client specification in realm scope mappings");
                }
                for (String roleString : scope.getRoles()) {
                    RoleModel role = newRealm.getRole(roleString.trim());
                    if (role == null) {
                        role = newRealm.addRole(roleString.trim());
                    }
                    client.addScopeMapping(role);
                }
            }
        }
        if (rep.getSmtpServer() != null) {
            newRealm.setSmtpConfig(new HashMap<String, String>(rep.getSmtpServer()));
        }
        if (rep.getBrowserSecurityHeaders() != null) {
            newRealm.setBrowserSecurityHeaders(rep.getBrowserSecurityHeaders());
        } else {
            newRealm.setBrowserSecurityHeaders(BrowserSecurityHeaders.defaultHeaders);
        }
        if (rep.getSocialProviders() != null) {
            newRealm.setSocialConfig(new HashMap<String, String>(rep.getSocialProviders()));
        }
        if (rep.getUserFederationProviders() != null) {
            List<UserFederationProviderModel> list = RepresentationToModel.convertFederationProviders(rep.getUserFederationProviders());
            newRealm.setUserFederationProviders(list);
        }
        if (rep.getUsers() != null) {
            for (UserRepresentation userRep : rep.getUsers()) {
                UserModel user = RepresentationToModel.createUser(session, newRealm, userRep, appMap);
            }
        }
    }

    public static void updateRealm(RealmRepresentation rep, RealmModel realm) {
        if (rep.getRealm() != null) {
            realm.setName(rep.getRealm());
        }
        if (rep.isEnabled() != null) {
            realm.setEnabled(rep.isEnabled());
        }
        if (rep.isSocial() != null) {
            realm.setSocial(rep.isSocial());
        }
        if (rep.isBruteForceProtected() != null) {
            realm.setBruteForceProtected(rep.isBruteForceProtected());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            realm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            realm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            realm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            realm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            realm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds());
        }
        if (rep.getFailureFactor() != null) {
            realm.setFailureFactor(rep.getFailureFactor());
        }
        if (rep.isPasswordCredentialGrantAllowed() != null) {
            realm.setPasswordCredentialGrantAllowed(rep.isPasswordCredentialGrantAllowed());
        }
        if (rep.isRegistrationAllowed() != null) {
            realm.setRegistrationAllowed(rep.isRegistrationAllowed());
        }
        if (rep.isRememberMe() != null) {
            realm.setRememberMe(rep.isRememberMe());
        }
        if (rep.isVerifyEmail() != null) {
            realm.setVerifyEmail(rep.isVerifyEmail());
        }
        if (rep.isResetPasswordAllowed() != null) {
            realm.setResetPasswordAllowed(rep.isResetPasswordAllowed());
        }
        if (rep.isUpdateProfileOnInitialSocialLogin() != null) {
            realm.setUpdateProfileOnInitialSocialLogin(rep.isUpdateProfileOnInitialSocialLogin());
        }
        if (rep.getSslRequired() != null) {
            realm.setSslRequired(SslRequired.valueOf((String)rep.getSslRequired().toUpperCase()));
        }
        if (rep.getAccessCodeLifespan() != null) {
            realm.setAccessCodeLifespan(rep.getAccessCodeLifespan());
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            realm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction());
        }
        if (rep.getNotBefore() != null) {
            realm.setNotBefore(rep.getNotBefore());
        }
        if (rep.getAccessTokenLifespan() != null) {
            realm.setAccessTokenLifespan(rep.getAccessTokenLifespan());
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            realm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout());
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            realm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan());
        }
        if (rep.getRequiredCredentials() != null) {
            realm.updateRequiredCredentials(rep.getRequiredCredentials());
        }
        if (rep.getLoginTheme() != null) {
            realm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            realm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            realm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            realm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.getPasswordPolicy() != null) {
            realm.setPasswordPolicy(new PasswordPolicy(rep.getPasswordPolicy()));
        }
        if (rep.getDefaultRoles() != null) {
            realm.updateDefaultRoles(rep.getDefaultRoles().toArray(new String[rep.getDefaultRoles().size()]));
        }
        if (rep.getSmtpServer() != null) {
            realm.setSmtpConfig(new HashMap<String, String>(rep.getSmtpServer()));
        }
        if (rep.getSocialProviders() != null) {
            realm.setSocialConfig(new HashMap<String, String>(rep.getSocialProviders()));
        }
        if (rep.getBrowserSecurityHeaders() != null) {
            realm.setBrowserSecurityHeaders(rep.getBrowserSecurityHeaders());
        }
        if (rep.getUserFederationProviders() != null) {
            List<UserFederationProviderModel> providerModels = RepresentationToModel.convertFederationProviders(rep.getUserFederationProviders());
            realm.setUserFederationProviders(providerModels);
        }
        if ("GENERATE".equals(rep.getPublicKey())) {
            KeycloakModelUtils.generateRealmKeys(realm);
        }
    }

    public static void addRequiredCredential(RealmModel newRealm, String requiredCred) {
        newRealm.addRequiredCredential(requiredCred);
    }

    private static List<UserFederationProviderModel> convertFederationProviders(List<UserFederationProviderRepresentation> providers) {
        ArrayList<UserFederationProviderModel> result = new ArrayList<UserFederationProviderModel>();
        for (UserFederationProviderRepresentation representation : providers) {
            UserFederationProviderModel model = new UserFederationProviderModel(representation.getId(), representation.getProviderName(), representation.getConfig(), representation.getPriority(), representation.getDisplayName(), representation.getFullSyncPeriod(), representation.getChangedSyncPeriod(), representation.getLastSync());
            result.add(model);
        }
        return result;
    }

    public static void createRole(RealmModel newRealm, RoleRepresentation roleRep) {
        RoleModel role;
        RoleModel roleModel = role = roleRep.getId() != null ? newRealm.addRole(roleRep.getId(), roleRep.getName()) : newRealm.addRole(roleRep.getName());
        if (roleRep.getDescription() != null) {
            role.setDescription(roleRep.getDescription());
        }
    }

    private static void addComposites(RoleModel role, RoleRepresentation roleRep, RealmModel realm) {
        if (roleRep.getComposites() == null) {
            return;
        }
        if (roleRep.getComposites().getRealm() != null) {
            for (String string : roleRep.getComposites().getRealm()) {
                RoleModel realmRole = realm.getRole(string);
                if (realmRole == null) {
                    throw new RuntimeException("Unable to find composite realm role: " + string);
                }
                role.addCompositeRole(realmRole);
            }
        }
        if (roleRep.getComposites().getApplication() != null) {
            for (Map.Entry entry : roleRep.getComposites().getApplication().entrySet()) {
                ApplicationModel app = realm.getApplicationByName((String)entry.getKey());
                if (app == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + roleRep.getName());
                }
                for (String roleStr : (List)entry.getValue()) {
                    RoleModel appRole = app.getRole(roleStr);
                    if (appRole == null) {
                        throw new RuntimeException("Unable to find composite app role: " + roleStr);
                    }
                    role.addCompositeRole(appRole);
                }
            }
        }
    }

    private static Map<String, ApplicationModel> createApplications(RealmRepresentation rep, RealmModel realm) {
        HashMap<String, ApplicationModel> appMap = new HashMap<String, ApplicationModel>();
        for (ApplicationRepresentation resourceRep : rep.getApplications()) {
            ApplicationModel app = RepresentationToModel.createApplication(realm, resourceRep, false);
            appMap.put(app.getName(), app);
        }
        return appMap;
    }

    public static ApplicationModel createApplication(RealmModel realm, ApplicationRepresentation resourceRep, boolean addDefaultRoles) {
        ApplicationModel applicationModel;
        logger.debug((Object)("************ CREATE APPLICATION: {0}" + resourceRep.getName()));
        ApplicationModel applicationModel2 = applicationModel = resourceRep.getId() != null ? realm.addApplication(resourceRep.getId(), resourceRep.getName()) : realm.addApplication(resourceRep.getName());
        if (resourceRep.isEnabled() != null) {
            applicationModel.setEnabled(resourceRep.isEnabled());
        }
        applicationModel.setManagementUrl(resourceRep.getAdminUrl());
        if (resourceRep.isSurrogateAuthRequired() != null) {
            applicationModel.setSurrogateAuthRequired(resourceRep.isSurrogateAuthRequired());
        }
        applicationModel.setBaseUrl(resourceRep.getBaseUrl());
        if (resourceRep.isBearerOnly() != null) {
            applicationModel.setBearerOnly(resourceRep.isBearerOnly());
        }
        if (resourceRep.isPublicClient() != null) {
            applicationModel.setPublicClient(resourceRep.isPublicClient());
        }
        if (resourceRep.isFullScopeAllowed() != null) {
            applicationModel.setFullScopeAllowed(resourceRep.isFullScopeAllowed());
        } else {
            applicationModel.setFullScopeAllowed(true);
        }
        applicationModel.updateApplication();
        if (resourceRep.getNotBefore() != null) {
            applicationModel.setNotBefore(resourceRep.getNotBefore());
        }
        applicationModel.setSecret(resourceRep.getSecret());
        if (applicationModel.getSecret() == null) {
            KeycloakModelUtils.generateSecret(applicationModel);
        }
        if (resourceRep.getRedirectUris() != null) {
            for (String redirectUri : resourceRep.getRedirectUris()) {
                applicationModel.addRedirectUri(redirectUri);
            }
        }
        if (resourceRep.getWebOrigins() != null) {
            for (String webOrigin : resourceRep.getWebOrigins()) {
                logger.debugv("Application: {0} webOrigin: {1}", (Object)resourceRep.getName(), (Object)webOrigin);
                applicationModel.addWebOrigin(webOrigin);
            }
        } else if (resourceRep.getRedirectUris() != null) {
            HashSet<String> origins = new HashSet<String>();
            for (String redirectUri : resourceRep.getRedirectUris()) {
                logger.debugv("add redirect-uri to origin: {0}", (Object)redirectUri);
                if (!redirectUri.startsWith("http:")) continue;
                URI uri = URI.create(redirectUri);
                String origin = uri.getScheme() + "://" + uri.getHost();
                if (uri.getPort() != -1) {
                    origin = origin + ":" + uri.getPort();
                }
                logger.debugv("adding default application origin: {0}", (Object)origin);
                origins.add(origin);
            }
            if (origins.size() > 0) {
                applicationModel.setWebOrigins(origins);
            }
        }
        if (addDefaultRoles && resourceRep.getDefaultRoles() != null) {
            applicationModel.updateDefaultRoles(resourceRep.getDefaultRoles());
        }
        if (resourceRep.getClaims() != null) {
            RepresentationToModel.setClaims(applicationModel, resourceRep.getClaims());
        } else {
            applicationModel.setAllowedClaimsMask(1023L);
        }
        return applicationModel;
    }

    public static void updateApplication(ApplicationRepresentation rep, ApplicationModel resource) {
        List webOrigins;
        List redirectUris;
        if (rep.getName() != null) {
            resource.setName(rep.getName());
        }
        if (rep.isEnabled() != null) {
            resource.setEnabled(rep.isEnabled());
        }
        if (rep.isBearerOnly() != null) {
            resource.setBearerOnly(rep.isBearerOnly());
        }
        if (rep.isPublicClient() != null) {
            resource.setPublicClient(rep.isPublicClient());
        }
        if (rep.isFullScopeAllowed() != null) {
            resource.setFullScopeAllowed(rep.isFullScopeAllowed());
        }
        if (rep.getAdminUrl() != null) {
            resource.setManagementUrl(rep.getAdminUrl());
        }
        if (rep.getBaseUrl() != null) {
            resource.setBaseUrl(rep.getBaseUrl());
        }
        if (rep.isSurrogateAuthRequired() != null) {
            resource.setSurrogateAuthRequired(rep.isSurrogateAuthRequired());
        }
        resource.updateApplication();
        if (rep.getNotBefore() != null) {
            resource.setNotBefore(rep.getNotBefore());
        }
        if (rep.getDefaultRoles() != null) {
            resource.updateDefaultRoles(rep.getDefaultRoles());
        }
        if ((redirectUris = rep.getRedirectUris()) != null) {
            resource.setRedirectUris(new HashSet<String>(redirectUris));
        }
        if ((webOrigins = rep.getWebOrigins()) != null) {
            resource.setWebOrigins(new HashSet<String>(webOrigins));
        }
        if (rep.getClaims() != null) {
            RepresentationToModel.setClaims(resource, rep.getClaims());
        }
    }

    public static void setClaims(ClientModel model, ClaimRepresentation rep) {
        long mask = model.getAllowedClaimsMask();
        mask = rep.getAddress() ? (mask |= 0x100L) : (mask &= 0xFFFFFFFFFFFFFEFFL);
        mask = rep.getEmail() ? (mask |= 0x20L) : (mask &= 0xFFFFFFFFFFFFFFDFL);
        mask = rep.getGender() ? (mask |= 0x40L) : (mask &= 0xFFFFFFFFFFFFFFBFL);
        mask = rep.getLocale() ? (mask |= 0x80L) : (mask &= 0xFFFFFFFFFFFFFF7FL);
        mask = rep.getName() ? (mask |= 1L) : (mask &= 0xFFFFFFFFFFFFFFFEL);
        mask = rep.getPhone() ? (mask |= 0x200L) : (mask &= 0xFFFFFFFFFFFFFDFFL);
        mask = rep.getPicture() ? (mask |= 8L) : (mask &= 0xFFFFFFFFFFFFFFF7L);
        mask = rep.getProfile() ? (mask |= 4L) : (mask &= 0xFFFFFFFFFFFFFFFBL);
        mask = rep.getUsername() ? (mask |= 2L) : (mask &= 0xFFFFFFFFFFFFFFFDL);
        mask = rep.getWebsite() ? (mask |= 0x10L) : (mask &= 0xFFFFFFFFFFFFFFEFL);
        model.setAllowedClaimsMask(mask);
    }

    private static void createOAuthClients(RealmRepresentation realmRep, RealmModel realm) {
        for (OAuthClientRepresentation rep : realmRep.getOauthClients()) {
            RepresentationToModel.createOAuthClient(rep, realm);
        }
    }

    public static OAuthClientModel createOAuthClient(String id, String name, RealmModel realm) {
        OAuthClientModel model = id != null ? realm.addOAuthClient(id, name) : realm.addOAuthClient(name);
        KeycloakModelUtils.generateSecret(model);
        return model;
    }

    public static OAuthClientModel createOAuthClient(OAuthClientRepresentation rep, RealmModel realm) {
        OAuthClientModel model = RepresentationToModel.createOAuthClient(rep.getId(), rep.getName(), realm);
        RepresentationToModel.updateOAuthClient(rep, model);
        return model;
    }

    public static void updateOAuthClient(OAuthClientRepresentation rep, OAuthClientModel model) {
        List webOrigins;
        List redirectUris;
        if (rep.getName() != null) {
            model.setClientId(rep.getName());
        }
        if (rep.isEnabled() != null) {
            model.setEnabled(rep.isEnabled());
        }
        if (rep.isPublicClient() != null) {
            model.setPublicClient(rep.isPublicClient());
        }
        if (rep.isFullScopeAllowed() != null) {
            model.setFullScopeAllowed(rep.isFullScopeAllowed());
        }
        if (rep.isDirectGrantsOnly() != null) {
            model.setDirectGrantsOnly(rep.isDirectGrantsOnly());
        }
        if (rep.getClaims() != null) {
            RepresentationToModel.setClaims(model, rep.getClaims());
        }
        if (rep.getNotBefore() != null) {
            model.setNotBefore(rep.getNotBefore());
        }
        if (rep.getSecret() != null) {
            model.setSecret(rep.getSecret());
        }
        if ((redirectUris = rep.getRedirectUris()) != null) {
            model.setRedirectUris(new HashSet<String>(redirectUris));
        }
        if ((webOrigins = rep.getWebOrigins()) != null) {
            model.setWebOrigins(new HashSet<String>(webOrigins));
        }
        if (rep.getClaims() != null) {
            RepresentationToModel.setClaims(model, rep.getClaims());
        }
        if (rep.getNotBefore() != null) {
            model.setNotBefore(rep.getNotBefore());
        }
    }

    public static void createApplicationScopeMappings(RealmModel realm, ApplicationModel applicationModel, List<ScopeMappingRepresentation> mappings) {
        for (ScopeMappingRepresentation mapping : mappings) {
            ClientModel client = realm.findClient(mapping.getClient());
            if (client == null) {
                throw new RuntimeException("Unknown client specified in application scope mappings");
            }
            for (String roleString : mapping.getRoles()) {
                RoleModel role = applicationModel.getRole(roleString.trim());
                if (role == null) {
                    role = applicationModel.addRole(roleString.trim());
                }
                client.addScopeMapping(role);
            }
        }
    }

    public static UserModel createUser(KeycloakSession session, RealmModel newRealm, UserRepresentation userRep, Map<String, ApplicationModel> appMap) {
        UserModel user = session.userStorage().addUser(newRealm, userRep.getId(), userRep.getUsername(), false);
        user.setEnabled(userRep.isEnabled());
        user.setEmail(userRep.getEmail());
        user.setFirstName(userRep.getFirstName());
        user.setLastName(userRep.getLastName());
        user.setFederationLink(userRep.getFederationLink());
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                user.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String requiredAction : userRep.getRequiredActions()) {
                user.addRequiredAction(UserModel.RequiredAction.valueOf(requiredAction));
            }
        }
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                RepresentationToModel.updateCredential(user, cred);
            }
        }
        if (userRep.getSocialLinks() != null) {
            for (SocialLinkRepresentation socialLink : userRep.getSocialLinks()) {
                SocialLinkModel mappingModel = new SocialLinkModel(socialLink.getSocialProvider(), socialLink.getSocialUserId(), socialLink.getSocialUsername());
                session.users().addSocialLink(newRealm, user, mappingModel);
            }
        }
        if (userRep.getRealmRoles() != null) {
            for (String roleString : userRep.getRealmRoles()) {
                RoleModel role = newRealm.getRole(roleString.trim());
                if (role == null) {
                    role = newRealm.addRole(roleString.trim());
                }
                user.grantRole(role);
            }
        }
        if (userRep.getApplicationRoles() != null) {
            for (Map.Entry entry : userRep.getApplicationRoles().entrySet()) {
                ApplicationModel app = appMap.get(entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find application role mappings for app: " + (String)entry.getKey());
                }
                RepresentationToModel.createApplicationRoleMappings(app, user, (List)entry.getValue());
            }
        }
        return user;
    }

    private static void updateCredential(UserModel user, CredentialRepresentation cred) {
        if (cred.getValue() != null) {
            UserCredentialModel plainTextCred = RepresentationToModel.convertCredential(cred);
            user.updateCredential(plainTextCred);
        } else {
            UserCredentialValueModel hashedCred = new UserCredentialValueModel();
            hashedCred.setType(cred.getType());
            hashedCred.setDevice(cred.getDevice());
            hashedCred.setHashIterations(cred.getHashIterations());
            try {
                hashedCred.setSalt(Base64.decode((String)cred.getSalt()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            hashedCred.setValue(cred.getHashedSaltedValue());
            user.updateCredentialDirectly(hashedCred);
        }
    }

    public static UserCredentialModel convertCredential(CredentialRepresentation cred) {
        UserCredentialModel credential = new UserCredentialModel();
        credential.setType(cred.getType());
        credential.setValue(cred.getValue());
        return credential;
    }

    public static void createApplicationRoleMappings(ApplicationModel applicationModel, UserModel user, List<String> roleNames) {
        if (user == null) {
            throw new RuntimeException("User not found");
        }
        for (String roleName : roleNames) {
            RoleModel role = applicationModel.getRole(roleName.trim());
            if (role == null) {
                role = applicationModel.addRole(roleName.trim());
            }
            user.grantRole(role);
        }
    }
}

