/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.settings;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.helper.InterruptHook;
import org.jboss.aesh.console.settings.DefaultAeshContext;
import org.jboss.aesh.console.settings.FileAccessPermission;
import org.jboss.aesh.console.settings.QuitHandler;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.edit.EditMode;
import org.jboss.aesh.edit.EmacsEditMode;
import org.jboss.aesh.edit.KeyOperationFactory;
import org.jboss.aesh.edit.KeyOperationManager;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.ViEditMode;
import org.jboss.aesh.io.FileResource;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.terminal.POSIXTerminal;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.WindowsTerminal;

public class SettingsImpl
implements Settings {
    private String name;
    private Mode editMode = Mode.EMACS;
    private File historyFile;
    private FileAccessPermission historyFilePermission;
    private int historySize = 500;
    private boolean historyDisabled = false;
    private boolean historyPersistent = true;
    private String bellStyle;
    private boolean ansiConsole = true;
    private InputStream inputStream;
    private PrintStream stdOut;
    private PrintStream stdErr;
    private Terminal terminal;
    private boolean readInputrc = true;
    private File inputrc;
    private boolean isLogging = false;
    private String logFile;
    private boolean disableCompletion = false;
    private QuitHandler quitHandler;
    private KeyOperationManager operationManager = new KeyOperationManager();
    private File aliasFile;
    private boolean aliasEnabled = true;
    private boolean persistAlias = true;
    private InterruptHook interruptHook = null;
    private boolean enableOperatorParser = true;
    private boolean manEnabled = true;
    private AeshContext aeshContext;
    private boolean exportEnabled = true;
    private File exportFile;
    private boolean persistExport = true;
    private boolean exportUsesSystemEnvironment = false;
    private Resource resource;
    private String execute;
    private Resource executeFileAtStart;
    private boolean parsingQuotes = true;

    protected SettingsImpl() {
    }

    protected SettingsImpl(Settings baseSettings) {
        this.setName(baseSettings.getName());
        this.setMode(baseSettings.getMode());
        this.setHistoryFile(baseSettings.getHistoryFile());
        this.setHistoryFilePermission(baseSettings.getHistoryFilePermission());
        this.setHistorySize(baseSettings.getHistorySize());
        this.setBellStyle(baseSettings.getBellStyle());
        this.setAnsiConsole(baseSettings.isAnsiConsole());
        this.setInputStream(baseSettings.getInputStream());
        this.setStdOut(baseSettings.getStdOut());
        this.setStdErr(baseSettings.getStdErr());
        this.setTerminal(baseSettings.getTerminal());
        this.setInputrc(baseSettings.getInputrc());
        this.setLogging(baseSettings.isLogging());
        this.setDisableCompletion(baseSettings.isCompletionDisabled());
        this.setLogFile(baseSettings.getLogFile());
        this.setReadInputrc(baseSettings.doReadInputrc());
        this.setHistoryDisabled(baseSettings.isHistoryDisabled());
        this.setHistoryPersistent(baseSettings.isHistoryPersistent());
        this.setAliasFile(baseSettings.getAliasFile());
        this.setAliasEnabled(baseSettings.isAliasEnabled());
        this.setPersistAlias(baseSettings.doPersistAlias());
        this.setQuitHandler(baseSettings.getQuitHandler());
        this.setInterruptHook(baseSettings.getInterruptHook());
        this.enableOperatorParser(baseSettings.isOperatorParserEnabled());
        this.setManEnabled(baseSettings.isManEnabled());
        this.setAeshContext(baseSettings.getAeshContext());
        this.setExportEnabled(baseSettings.isExportEnabled());
        this.setExportFile(baseSettings.getExportFile());
        this.setPersistExport(baseSettings.doPersistExport());
        this.setResource(baseSettings.getResource());
        this.setExportUsesSystemEnvironment(baseSettings.doExportUsesSystemEnvironment());
        this.setExecuteAtStart(baseSettings.getExecuteAtStart());
        this.setParsingQuotes(baseSettings.isParsingQuotes());
    }

    public void resetToDefaults() {
        this.setName("aesh");
        this.editMode = Mode.EMACS;
        this.historyFile = null;
        this.historyFilePermission = null;
        this.historySize = 500;
        this.historyDisabled = false;
        this.historyPersistent = true;
        this.bellStyle = null;
        this.ansiConsole = true;
        this.inputStream = null;
        this.setStdOut(null);
        this.setStdErr(null);
        this.terminal = null;
        this.readInputrc = true;
        this.isLogging = false;
        this.logFile = null;
        this.disableCompletion = false;
        this.setQuitHandler(null);
        this.operationManager.clear();
        this.setAliasEnabled(true);
        this.parsingQuotes = true;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = "aesh";
        }
        return this.name;
    }

    @Override
    public Mode getMode() {
        return this.editMode;
    }

    public void setMode(Mode editMode) {
        this.editMode = editMode;
    }

    @Override
    public EditMode getEditMode() {
        if (Config.isOSPOSIXCompatible()) {
            if (this.getMode() == Mode.EMACS) {
                return new EmacsEditMode(this.getOperationManager());
            }
            return new ViEditMode(this.getOperationManager());
        }
        if (this.getMode() == Mode.EMACS) {
            return new EmacsEditMode(this.getOperationManager());
        }
        return new ViEditMode(this.getOperationManager());
    }

    @Override
    public void resetEditMode() {
        this.operationManager.clear();
    }

    @Override
    public KeyOperationManager getOperationManager() {
        if (this.operationManager.getOperations().size() < 1) {
            if (this.getMode() == Mode.EMACS) {
                this.operationManager.addOperations(KeyOperationFactory.generateEmacsMode());
            } else {
                this.operationManager.addOperations(KeyOperationFactory.generateViMode());
            }
        }
        return this.operationManager;
    }

    @Override
    public FileAccessPermission getHistoryFilePermission() {
        return this.historyFilePermission;
    }

    public void setHistoryFilePermission(FileAccessPermission historyFilePermission) {
        this.historyFilePermission = historyFilePermission;
    }

    @Override
    public File getHistoryFile() {
        if (this.historyFile == null) {
            return new File(System.getProperty("user.home") + Config.getPathSeparator() + ".aesh_history");
        }
        return this.historyFile;
    }

    public void setHistoryFile(File historyFile) {
        this.historyFile = historyFile;
    }

    @Override
    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
    }

    @Override
    public String getBellStyle() {
        return this.bellStyle;
    }

    public void setBellStyle(String bellStyle) {
        this.bellStyle = bellStyle;
    }

    @Override
    public boolean isAnsiConsole() {
        return this.ansiConsole;
    }

    public void setAnsiConsole(boolean ansiConsole) {
        this.ansiConsole = ansiConsole;
    }

    @Override
    public InputStream getInputStream() {
        if (this.inputStream == null) {
            this.inputStream = System.in;
        }
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public PrintStream getStdOut() {
        if (this.stdOut == null) {
            return System.out;
        }
        return this.stdOut;
    }

    public void setStdOut(PrintStream stdOut) {
        this.stdOut = stdOut;
    }

    @Override
    public PrintStream getStdErr() {
        if (this.stdErr == null) {
            return System.err;
        }
        return this.stdErr;
    }

    public void setStdErr(PrintStream stdErr) {
        this.stdErr = stdErr;
    }

    @Override
    public Terminal getTerminal() {
        if (this.terminal == null) {
            this.terminal = Config.isOSPOSIXCompatible() ? new POSIXTerminal() : new WindowsTerminal();
        }
        return this.terminal;
    }

    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    @Override
    public File getInputrc() {
        if (this.inputrc == null) {
            this.inputrc = new File(System.getProperty("user.home") + Config.getPathSeparator() + ".inputrc");
        }
        return this.inputrc;
    }

    public void setInputrc(File inputrc) {
        this.inputrc = inputrc;
    }

    @Override
    public boolean isLogging() {
        return this.isLogging;
    }

    public void setLogging(boolean logging) {
        this.isLogging = logging;
    }

    @Override
    public boolean isCompletionDisabled() {
        return this.disableCompletion;
    }

    public void setDisableCompletion(boolean disableCompletion) {
        this.disableCompletion = disableCompletion;
    }

    @Override
    public String getLogFile() {
        if (this.logFile == null) {
            this.logFile = Config.getTmpDir() + Config.getPathSeparator() + "aesh.log";
        }
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    @Override
    public boolean doReadInputrc() {
        return this.readInputrc;
    }

    public void setReadInputrc(boolean readInputrc) {
        this.readInputrc = readInputrc;
    }

    @Override
    public boolean isHistoryDisabled() {
        return this.historyDisabled;
    }

    public void setHistoryDisabled(boolean historyDisabled) {
        this.historyDisabled = historyDisabled;
    }

    @Override
    public boolean isHistoryPersistent() {
        return this.historyPersistent;
    }

    public void setHistoryPersistent(boolean historyPersistent) {
        this.historyPersistent = historyPersistent;
    }

    public void setAliasFile(File file) {
        this.aliasFile = file;
    }

    @Override
    public File getAliasFile() {
        if (this.aliasFile == null) {
            this.aliasFile = new File(Config.getHomeDir() + Config.getPathSeparator() + ".aesh_aliases");
        }
        return this.aliasFile;
    }

    @Override
    public boolean isAliasEnabled() {
        return this.aliasEnabled;
    }

    public void setAliasEnabled(boolean enabled) {
        this.aliasEnabled = enabled;
    }

    public void setPersistAlias(boolean persist) {
        this.persistAlias = persist;
    }

    @Override
    public boolean doPersistAlias() {
        return this.persistAlias;
    }

    public void setQuitHandler(QuitHandler qh) {
        this.quitHandler = qh;
    }

    @Override
    public QuitHandler getQuitHandler() {
        return this.quitHandler;
    }

    public void setInterruptHook(InterruptHook hook) {
        this.interruptHook = hook;
    }

    @Override
    public boolean hasInterruptHook() {
        return this.interruptHook != null;
    }

    @Override
    public InterruptHook getInterruptHook() {
        return this.interruptHook;
    }

    public void enableOperatorParser(boolean enable) {
        this.enableOperatorParser = enable;
    }

    @Override
    public boolean isOperatorParserEnabled() {
        return this.enableOperatorParser;
    }

    @Override
    public void switchMode() {
        this.editMode = this.editMode == Mode.VI ? Mode.EMACS : Mode.VI;
    }

    @Override
    public boolean isManEnabled() {
        return this.manEnabled;
    }

    public void setManEnabled(boolean enabled) {
        this.manEnabled = enabled;
    }

    @Override
    public AeshContext getAeshContext() {
        if (this.aeshContext == null) {
            this.aeshContext = new DefaultAeshContext(this.getResource().newInstance(Config.getUserDir()));
        }
        return this.aeshContext;
    }

    public void setAeshContext(AeshContext aeshContext) {
        this.aeshContext = aeshContext;
    }

    @Override
    public File getExportFile() {
        if (this.exportFile == null) {
            this.exportFile = new File(Config.getHomeDir() + Config.getPathSeparator() + ".aesh_export");
        }
        return this.exportFile;
    }

    public void setExportFile(File exportFile) {
        if (exportFile != null) {
            this.exportFile = exportFile;
        }
    }

    @Override
    public boolean isExportEnabled() {
        return this.exportEnabled;
    }

    public void setExportEnabled(boolean exportEnabled) {
        this.exportEnabled = exportEnabled;
    }

    @Override
    public void setPersistExport(boolean persistExport) {
        this.persistExport = persistExport;
    }

    @Override
    public boolean doPersistExport() {
        return this.persistExport;
    }

    @Override
    public void setExportUsesSystemEnvironment(boolean isLoad) {
        this.exportUsesSystemEnvironment = isLoad;
    }

    @Override
    public boolean doExportUsesSystemEnvironment() {
        return this.exportUsesSystemEnvironment;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public void setExecuteAtStart(String execute) {
        this.execute = execute.endsWith(Config.getLineSeparator()) ? execute : execute + Config.getLineSeparator();
    }

    @Override
    public String getExecuteAtStart() {
        return this.execute;
    }

    @Override
    public void setExecuteFileAtStart(Resource executeFileAtStart) {
        this.executeFileAtStart = executeFileAtStart;
    }

    @Override
    public boolean isParsingQuotes() {
        return this.parsingQuotes;
    }

    public void setParsingQuotes(boolean parsingQuotes) {
        this.parsingQuotes = parsingQuotes;
    }

    @Override
    public Resource getExecuteFileAtStart() {
        return this.executeFileAtStart;
    }

    @Override
    public Resource getResource() {
        if (this.resource == null) {
            this.resource = new FileResource("");
        }
        return this.resource;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

