/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import org.keycloak.models.KeycloakContext;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.BlacklistPasswordPolicyProviderFactory;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class BlacklistPasswordPolicyProvider
implements PasswordPolicyProvider {
    public static final String ERROR_MESSAGE = "invalidPasswordBlacklistedMessage";
    private final KeycloakContext context;
    private final BlacklistPasswordPolicyProviderFactory factory;

    public BlacklistPasswordPolicyProvider(KeycloakContext context, BlacklistPasswordPolicyProviderFactory factory) {
        this.context = context;
        this.factory = factory;
    }

    @Override
    public PolicyError validate(String username, String password) {
        Object policyConfig = this.context.getRealm().getPasswordPolicy().getPolicyConfig("passwordBlacklist");
        if (policyConfig == null) {
            return null;
        }
        if (!(policyConfig instanceof BlacklistPasswordPolicyProviderFactory.PasswordBlacklist)) {
            return null;
        }
        BlacklistPasswordPolicyProviderFactory.FileBasedPasswordBlacklist blacklist = (BlacklistPasswordPolicyProviderFactory.FileBasedPasswordBlacklist)policyConfig;
        if (!blacklist.contains(password.toLowerCase())) {
            return null;
        }
        return new PolicyError(ERROR_MESSAGE, new Object[0]);
    }

    @Override
    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        return this.validate(user.getUsername(), password);
    }

    @Override
    public Object parseConfig(String blacklistName) {
        if (blacklistName == null) {
            return null;
        }
        return this.factory.resolvePasswordBlacklist(blacklistName);
    }

    @Override
    public void close() {
    }
}

