/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.console.AeshConsole;
import org.jboss.aesh.console.AeshConsoleImpl;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.activator.AeshCommandActivatorProvider;
import org.jboss.aesh.console.command.activator.AeshOptionActivatorProvider;
import org.jboss.aesh.console.command.activator.CommandActivatorProvider;
import org.jboss.aesh.console.command.activator.OptionActivatorProvider;
import org.jboss.aesh.console.command.completer.AeshCompleterInvocationProvider;
import org.jboss.aesh.console.command.completer.CompleterInvocationProvider;
import org.jboss.aesh.console.command.converter.AeshConverterInvocationProvider;
import org.jboss.aesh.console.command.converter.ConverterInvocationProvider;
import org.jboss.aesh.console.command.invocation.CommandInvocationServices;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.command.registry.MutableCommandRegistry;
import org.jboss.aesh.console.command.validator.AeshValidatorInvocationProvider;
import org.jboss.aesh.console.command.validator.ValidatorInvocationProvider;
import org.jboss.aesh.console.helper.ManProvider;
import org.jboss.aesh.console.settings.CommandNotFoundHandler;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;

public class AeshConsoleBuilder {
    private Settings settings;
    private Prompt prompt;
    private CommandRegistry registry;
    private CommandInvocationServices commandInvocationServices;
    private CommandNotFoundHandler commandNotFoundHandler;
    private ManProvider manProvider;
    private CompleterInvocationProvider completerInvocationProvider;
    private ConverterInvocationProvider converterInvocationProvider;
    private ValidatorInvocationProvider validatorInvocationProvider;
    private OptionActivatorProvider optionActivatorProvider;
    private CommandActivatorProvider commandActivatorProvider;
    private List<Command> commands = new ArrayList<Command>();
    private String execute;

    public AeshConsoleBuilder commandRegistry(CommandRegistry registry) {
        this.registry = registry;
        return this;
    }

    public AeshConsoleBuilder settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public AeshConsoleBuilder prompt(Prompt prompt) {
        this.prompt = prompt;
        return this;
    }

    public AeshConsoleBuilder commandInvocationProvider(CommandInvocationServices commandInvocationServices) {
        this.commandInvocationServices = commandInvocationServices;
        return this;
    }

    public AeshConsoleBuilder commandNotFoundHandler(CommandNotFoundHandler commandNotFoundHandler) {
        this.commandNotFoundHandler = commandNotFoundHandler;
        return this;
    }

    public AeshConsoleBuilder completerInvocationProvider(CompleterInvocationProvider completerInvocationProvider) {
        this.completerInvocationProvider = completerInvocationProvider;
        return this;
    }

    public AeshConsoleBuilder converterInvocationProvider(ConverterInvocationProvider converterInvocationProvider) {
        this.converterInvocationProvider = converterInvocationProvider;
        return this;
    }

    public AeshConsoleBuilder validatorInvocationProvider(ValidatorInvocationProvider validatorInvocationProvider) {
        this.validatorInvocationProvider = validatorInvocationProvider;
        return this;
    }

    public AeshConsoleBuilder optionActivatorProvider(OptionActivatorProvider optionActivatorProvider) {
        this.optionActivatorProvider = optionActivatorProvider;
        return this;
    }

    public AeshConsoleBuilder commandActivatorProvider(CommandActivatorProvider commandActivatorProvider) {
        this.commandActivatorProvider = commandActivatorProvider;
        return this;
    }

    public AeshConsoleBuilder manProvider(ManProvider manProvider) {
        this.manProvider = manProvider;
        return this;
    }

    public AeshConsoleBuilder addCommand(Command command) {
        this.commands.add(command);
        return this;
    }

    public AeshConsoleBuilder executeAtStart(String execute) {
        this.execute = execute;
        return this;
    }

    public AeshConsole create() {
        if (this.settings == null) {
            this.settings = new SettingsBuilder().create();
        }
        if (this.registry == null) {
            this.registry = new MutableCommandRegistry();
        }
        if (this.commands.size() > 0 && this.registry instanceof MutableCommandRegistry) {
            ((MutableCommandRegistry)this.registry).addAllCommands(this.commands);
        }
        if (this.commandInvocationServices == null) {
            this.commandInvocationServices = new CommandInvocationServices();
        }
        if (this.completerInvocationProvider == null) {
            this.completerInvocationProvider = new AeshCompleterInvocationProvider();
        }
        if (this.converterInvocationProvider == null) {
            this.converterInvocationProvider = new AeshConverterInvocationProvider();
        }
        if (this.validatorInvocationProvider == null) {
            this.validatorInvocationProvider = new AeshValidatorInvocationProvider();
        }
        if (this.optionActivatorProvider == null) {
            this.optionActivatorProvider = new AeshOptionActivatorProvider();
        }
        if (this.commandActivatorProvider == null) {
            this.commandActivatorProvider = new AeshCommandActivatorProvider();
        }
        AeshConsoleImpl aeshConsole = new AeshConsoleImpl(this.settings, this.registry, this.commandInvocationServices, this.commandNotFoundHandler, this.completerInvocationProvider, this.converterInvocationProvider, this.validatorInvocationProvider, this.optionActivatorProvider, this.manProvider, this.commandActivatorProvider);
        if (this.prompt != null) {
            aeshConsole.setPrompt(this.prompt);
        }
        if (this.execute != null) {
            aeshConsole.execute(this.execute);
        }
        return aeshConsole;
    }
}

