/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.keycloak.admin.client.Config;
import org.keycloak.admin.client.resource.BearerAuthFilter;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.resource.ServerInfoResource;
import org.keycloak.admin.client.token.TokenManager;

public class Keycloak {
    private final Config config;
    private final TokenManager tokenManager;
    private String authToken;
    private final ResteasyWebTarget target;
    private final ResteasyClient client;
    private static final boolean authServerSslRequired = Boolean.parseBoolean(System.getProperty("auth.server.ssl.required"));

    Keycloak(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, String grantType, ResteasyClient resteasyClient, String authtoken) {
        this.config = new Config(serverUrl, realm, username, password, clientId, clientSecret, grantType);
        this.client = resteasyClient != null ? resteasyClient : new ResteasyClientBuilder().connectionPoolSize(10).build();
        this.authToken = authtoken;
        this.tokenManager = authtoken == null ? new TokenManager(this.config, this.client) : null;
        this.target = this.client.target(this.config.getServerUrl());
        this.target.register((Object)this.newAuthFilter());
    }

    private BearerAuthFilter newAuthFilter() {
        return this.authToken != null ? new BearerAuthFilter(this.authToken) : new BearerAuthFilter(this.tokenManager);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, SSLContext sslContext) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, clientSecret, sslContext, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, SSLContext sslContext, ResteasyJackson2Provider customJacksonProvider) {
        ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder().sslContext(sslContext).hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy.WILDCARD).connectionPoolSize(10);
        if (customJacksonProvider != null) {
            clientBuilder.register((Object)customJacksonProvider);
        }
        return new Keycloak(serverUrl, realm, username, password, clientId, clientSecret, "password", clientBuilder.build(), null);
    }

    private static ResteasyClientBuilder newResteasyClientBuilder() {
        if (authServerSslRequired) {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostName, SSLSession session) {
                    return true;
                }
            };
            return new ResteasyClientBuilder().disableTrustManager().hostnameVerifier(hostnameVerifier);
        }
        return new ResteasyClientBuilder();
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret) {
        return new Keycloak(serverUrl, realm, username, password, clientId, clientSecret, "password", null, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId) {
        return new Keycloak(serverUrl, realm, username, password, clientId, null, "password", null, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String clientId, String authToken) {
        return new Keycloak(serverUrl, realm, null, null, clientId, null, "password", null, authToken);
    }

    public RealmsResource realms() {
        return (RealmsResource)this.target.proxy(RealmsResource.class);
    }

    public RealmResource realm(String realmName) {
        return this.realms().realm(realmName);
    }

    public ServerInfoResource serverInfo() {
        return (ServerInfoResource)this.target.proxy(ServerInfoResource.class);
    }

    public TokenManager tokenManager() {
        return this.tokenManager;
    }

    public <T> T proxy(Class<T> proxyClass, URI absoluteURI) {
        return (T)this.client.target(absoluteURI).register((Object)this.newAuthFilter()).proxy(proxyClass);
    }

    public void close() {
        this.client.close();
    }

    public boolean isClosed() {
        return this.client.isClosed();
    }
}

