/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client;

import java.net.URI;
import javax.net.ssl.SSLContext;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.keycloak.admin.client.Config;
import org.keycloak.admin.client.resource.BearerAuthFilter;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.resource.ServerInfoResource;
import org.keycloak.admin.client.token.TokenManager;

public class Keycloak {
    private final Config config;
    private final TokenManager tokenManager;
    private String authToken;
    private final ResteasyWebTarget target;
    private final ResteasyClient client;

    Keycloak(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, String grantType, ResteasyClient resteasyClient, String authtoken) {
        this.config = new Config(serverUrl, realm, username, password, clientId, clientSecret, grantType);
        this.client = resteasyClient != null ? resteasyClient : new ResteasyClientBuilder().connectionPoolSize(10).build();
        this.authToken = authtoken;
        this.tokenManager = authtoken == null ? new TokenManager(this.config, this.client) : null;
        this.target = this.client.target(this.config.getServerUrl());
        this.target.register((Object)this.newAuthFilter());
    }

    private BearerAuthFilter newAuthFilter() {
        return this.authToken != null ? new BearerAuthFilter(this.authToken) : new BearerAuthFilter(this.tokenManager);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, SSLContext sslContext) {
        ResteasyClient client = new ResteasyClientBuilder().sslContext(sslContext).hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy.WILDCARD).connectionPoolSize(10).build();
        return new Keycloak(serverUrl, realm, username, password, clientId, clientSecret, "password", client, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret) {
        return new Keycloak(serverUrl, realm, username, password, clientId, clientSecret, "password", null, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId) {
        return new Keycloak(serverUrl, realm, username, password, clientId, null, "password", null, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String clientId, String authtoken) {
        return new Keycloak(serverUrl, realm, null, null, clientId, null, "password", null, null);
    }

    public RealmsResource realms() {
        return (RealmsResource)this.target.proxy(RealmsResource.class);
    }

    public RealmResource realm(String realmName) {
        return this.realms().realm(realmName);
    }

    public ServerInfoResource serverInfo() {
        return (ServerInfoResource)this.target.proxy(ServerInfoResource.class);
    }

    public TokenManager tokenManager() {
        return this.tokenManager;
    }

    public <T> T proxy(Class<T> proxyClass, URI absoluteURI) {
        return (T)this.client.target(absoluteURI).register((Object)this.newAuthFilter()).proxy(proxyClass);
    }

    public void close() {
        this.client.close();
    }
}

