/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.common;

import java.io.PrintWriter;
import picocli.CommandLine;

public class ShortErrorMessageHandler
implements CommandLine.IParameterExceptionHandler {
    @Override
    public int handleParseException(CommandLine.ParameterException ex, String[] args) {
        CommandLine cmd = ex.getCommandLine();
        return ShortErrorMessageHandler.shortErrorMessage(ex, cmd);
    }

    static int shortErrorMessage(Exception ex, CommandLine cmd) {
        PrintWriter writer = cmd.getErr();
        String errorMessage = ex.getMessage();
        writer.println(cmd.getColorScheme().errorText(errorMessage));
        if (ex instanceof CommandLine.ParameterException) {
            CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)ex, writer);
        }
        if (ex instanceof CommandLine.ParameterException || ex instanceof IllegalArgumentException) {
            CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
            writer.printf("Try '%s%s' for more information on the available options.%n", spec.qualifiedName(), "help".equals(spec.name()) ? "" : " --help");
            return cmd.getCommandSpec().exitCodeOnInvalidInput();
        }
        return cmd.getCommandSpec().exitCodeOnExecutionException();
    }
}

