/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.annotations.interception.Precedence;
import org.jboss.resteasy.core.interception.InterceptorRegistryListener;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;

@Deprecated
public class InterceptorRegistry<T> {
    protected ResteasyProviderFactory providerFactory;
    protected Class<T> intf;
    protected List<InterceptorFactory> interceptors = new ArrayList<InterceptorFactory>();
    protected Map<String, Integer> precedenceOrder = new HashMap<String, Integer>();
    protected List<String> precedenceList = new ArrayList<String>();
    protected List<InterceptorRegistryListener> listeners = new ArrayList<InterceptorRegistryListener>();

    public InterceptorRegistry<T> cloneTo(ResteasyProviderFactory factory) {
        InterceptorRegistry<T> clone = new InterceptorRegistry<T>(this.intf, factory);
        clone.interceptors.addAll(this.interceptors);
        clone.precedenceOrder.putAll(this.precedenceOrder);
        this.precedenceList.addAll(this.precedenceList);
        return clone;
    }

    public List<InterceptorRegistryListener> getListeners() {
        return this.listeners;
    }

    public Class<T> getIntf() {
        return this.intf;
    }

    public InterceptorRegistry(Class<T> intf, ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.intf = intf;
        this.precedenceOrder.put("DEFAULT", 100000);
    }

    protected void recalculateOrder() {
        this.precedenceOrder.clear();
        for (int i = 0; i < this.precedenceList.size(); ++i) {
            this.precedenceOrder.put(this.precedenceList.get(i), i);
        }
        this.precedenceOrder.put("DEFAULT", 100000);
    }

    public void appendPrecedence(String precedence) {
        this.precedenceList.add(precedence);
        this.recalculateOrder();
    }

    public void insertPrecedenceAfter(String after, String newPrecedence) {
        for (int i = 0; i < this.precedenceList.size(); ++i) {
            if (!this.precedenceList.get(i).equals(after)) continue;
            this.precedenceList.add(i + 1, newPrecedence);
            break;
        }
        this.recalculateOrder();
    }

    public void insertPrecedenceBefore(String after, String newPrecedence) {
        for (int i = 0; i < this.precedenceList.size(); ++i) {
            if (!this.precedenceList.get(i).equals(after)) continue;
            this.precedenceList.add(i, newPrecedence);
            break;
        }
        this.recalculateOrder();
    }

    public T[] bind(Class declaring, AccessibleObject target) {
        List<Object> list = this.bindForList(declaring, target);
        return list.toArray((Object[])Array.newInstance(this.intf, list.size()));
    }

    public List<T> bindForList(Class declaring, AccessibleObject target) {
        ArrayList list = new ArrayList();
        for (InterceptorFactory factory : this.interceptors) {
            Object interceptor = factory.postMatch(declaring, target);
            if (interceptor == null) continue;
            this.addNewInterceptor(list, interceptor);
        }
        return list;
    }

    protected void addNewInterceptor(List<T> list, Object interceptor) {
        this.providerFactory.injectProperties(interceptor);
        list.add(interceptor);
    }

    public void register(Class<? extends T> clazz) {
        this.interceptors.add(new PerMethodInterceptorFactory(clazz));
        Collections.sort(this.interceptors, new PrecedenceComparator());
        for (InterceptorRegistryListener listener : this.listeners) {
            listener.registryUpdated(this);
        }
    }

    public void register(T interceptor) {
        this.interceptors.add(new SingletonInterceptorFactory(interceptor));
        Collections.sort(this.interceptors, new PrecedenceComparator());
        for (InterceptorRegistryListener listener : this.listeners) {
            listener.registryUpdated(this);
        }
    }

    public class PrecedenceComparator
    implements Comparator<InterceptorFactory> {
        @Override
        public int compare(InterceptorFactory factory, InterceptorFactory factory2) {
            return factory.getOrder() - factory2.getOrder();
        }
    }

    protected class PerMethodInterceptorFactory
    extends AbstractInterceptorFactory {
        private ConstructorInjector constructorInjector;

        public PerMethodInterceptorFactory(Class clazz) {
            this.constructorInjector = InterceptorRegistry.this.providerFactory.createConstructorInjector(clazz);
            this.setPrecedence(clazz);
        }

        @Override
        public Object preMatch() {
            return null;
        }

        @Override
        public Object postMatch(Class declaring, AccessibleObject target) {
            Object inter = this.constructorInjector.construct();
            return this.binding(declaring, target, inter);
        }
    }

    protected class SingletonInterceptorFactory
    extends AbstractInterceptorFactory {
        private Object interceptor;

        public SingletonInterceptorFactory(Object interceptor) {
            this.interceptor = interceptor;
            this.setPrecedence(interceptor.getClass());
        }

        @Override
        public Object preMatch() {
            return null;
        }

        @Override
        public Object postMatch(Class declaring, AccessibleObject target) {
            Object inter = this.interceptor;
            return this.binding(declaring, target, inter);
        }
    }

    protected abstract class AbstractInterceptorFactory
    implements InterceptorFactory {
        protected String precedence = "DEFAULT";
        protected int order = 100000;

        protected AbstractInterceptorFactory() {
        }

        protected void setPrecedence(Class<?> clazz) {
            Precedence precedence = clazz.getAnnotation(Precedence.class);
            if (precedence != null) {
                this.precedence = precedence.value();
                Integer o = InterceptorRegistry.this.precedenceOrder.get(this.precedence);
                if (o == null) {
                    throw new RuntimeException(Messages.MESSAGES.unknownInterceptorPrecedence(this.precedence));
                }
                this.order = o;
            } else {
                for (Annotation annotation : clazz.getAnnotations()) {
                    precedence = annotation.annotationType().getAnnotation(Precedence.class);
                    if (precedence == null) continue;
                    this.precedence = precedence.value();
                    Integer o = InterceptorRegistry.this.precedenceOrder.get(this.precedence);
                    if (o == null) {
                        throw new RuntimeException(Messages.MESSAGES.unknownInterceptorPrecedence(this.precedence));
                    }
                    this.order = o;
                    break;
                }
            }
        }

        public String getPrecedence() {
            return this.precedence;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        protected Object binding(Class declaring, AccessibleObject target, Object inter) {
            if (inter instanceof AcceptedByMethod) {
                if (target == null || !(target instanceof Method)) {
                    return null;
                }
                Method method = (Method)target;
                if (((AcceptedByMethod)inter).accept(declaring, method)) {
                    return inter;
                }
                return null;
            }
            return inter;
        }
    }

    protected static interface InterceptorFactory {
        public Object preMatch();

        public Object postMatch(Class var1, AccessibleObject var2);

        public int getOrder();
    }
}

