/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs;

import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientWebTarget;

public class ResteasyClient
implements Client {
    protected volatile ClientHttpEngine httpEngine;
    protected volatile ExecutorService asyncInvocationExecutor;
    protected ClientConfiguration configuration;
    protected boolean closed;
    protected boolean cleanupExecutor;

    ResteasyClient(ClientHttpEngine httpEngine, ExecutorService asyncInvocationExecutor, boolean cleanupExecutor, ClientConfiguration configuration) {
        this.cleanupExecutor = cleanupExecutor;
        this.httpEngine = httpEngine;
        this.asyncInvocationExecutor = asyncInvocationExecutor;
        this.configuration = configuration;
    }

    public ClientHttpEngine httpEngine() {
        this.abortIfClosed();
        return this.httpEngine;
    }

    public ExecutorService asyncInvocationExecutor() {
        return this.asyncInvocationExecutor;
    }

    public void abortIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException(Messages.MESSAGES.clientIsClosed());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.httpEngine.close();
            if (this.cleanupExecutor) {
                if (System.getSecurityManager() == null) {
                    this.asyncInvocationExecutor.shutdown();
                } else {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            ResteasyClient.this.asyncInvocationExecutor.shutdown();
                            return null;
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Configuration getConfiguration() {
        this.abortIfClosed();
        return this.configuration;
    }

    @Override
    public SSLContext getSslContext() {
        this.abortIfClosed();
        return this.httpEngine().getSslContext();
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        this.abortIfClosed();
        return this.httpEngine().getHostnameVerifier();
    }

    @Override
    public ResteasyClient property(String name, Object value) {
        this.abortIfClosed();
        this.configuration.property(name, value);
        return this;
    }

    @Override
    public ResteasyClient register(Class<?> componentClass) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass);
        return this;
    }

    @Override
    public ResteasyClient register(Class<?> componentClass, int priority) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, priority);
        return this;
    }

    @Override
    public ResteasyClient register(Class<?> componentClass, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, (Class[])contracts);
        return this;
    }

    @Override
    public ResteasyClient register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, (Map)contracts);
        return this;
    }

    @Override
    public ResteasyClient register(Object component) {
        this.abortIfClosed();
        this.configuration.register(component);
        return this;
    }

    @Override
    public ResteasyClient register(Object component, int priority) {
        this.abortIfClosed();
        this.configuration.register(component, priority);
        return this;
    }

    @Override
    public ResteasyClient register(Object component, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    @Override
    public ResteasyClient register(Object component, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Map)contracts);
        return this;
    }

    @Override
    public ResteasyWebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        this.abortIfClosed();
        if (uri == null) {
            throw new NullPointerException(Messages.MESSAGES.uriWasNull());
        }
        return new ClientWebTarget(this, uri, this.configuration);
    }

    @Override
    public ResteasyWebTarget target(URI uri) throws NullPointerException {
        this.abortIfClosed();
        if (uri == null) {
            throw new NullPointerException(Messages.MESSAGES.uriWasNull());
        }
        return new ClientWebTarget(this, uri, this.configuration);
    }

    @Override
    public ResteasyWebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        this.abortIfClosed();
        if (uriBuilder == null) {
            throw new NullPointerException(Messages.MESSAGES.uriBuilderWasNull());
        }
        return new ClientWebTarget(this, uriBuilder, this.configuration);
    }

    @Override
    public ResteasyWebTarget target(Link link) throws NullPointerException {
        this.abortIfClosed();
        if (link == null) {
            throw new NullPointerException(Messages.MESSAGES.linkWasNull());
        }
        URI uri = link.getUri();
        return new ClientWebTarget(this, uri, this.configuration);
    }

    @Override
    public Invocation.Builder invocation(Link link) throws NullPointerException, IllegalArgumentException {
        this.abortIfClosed();
        if (link == null) {
            throw new NullPointerException(Messages.MESSAGES.linkWasNull());
        }
        ResteasyWebTarget target = this.target(link);
        if (link.getType() != null) {
            return target.request(link.getType());
        }
        return target.request();
    }
}

