/*
 * Decompiled with CFR 0.152.
 */
package sample.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="header", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class HeaderMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="index", property="masterFile", required=true)
    private String masterFileName;
    @Parameter(defaultValue="${project.build.directory}/sources", property="outputDir", required=true)
    private File outputDir;
    private File baseDir;
    private File topicsDir;

    public void execute() throws MojoExecutionException {
        try {
            this.baseDir = this.mavenProject.getBasedir();
            this.copy(new File(this.baseDir, this.masterFileName + ".adoc"));
            this.copy(new File(this.baseDir, "topics.adoc"));
            File docInfo = new File(this.baseDir, "docinfo.html");
            if (docInfo.isFile()) {
                this.copy(docInfo);
                this.copy(new File(this.baseDir, "docinfo-footer.html"));
            }
            this.topicsDir = new File(this.baseDir, "topics");
            this.processTopics(this.topicsDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void copy(File file) throws IOException {
        File out = new File(this.outputDir, file.getName());
        out.mkdirs();
        Files.copy(file.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void processTopics(File f) throws IOException {
        String topicsAbsolutePath = f.getAbsolutePath();
        String topicsParentDirPath = this.topicsDir.getParentFile().getAbsolutePath();
        if (this.isWindows()) {
            topicsAbsolutePath = topicsAbsolutePath.replace("\\", "/");
            topicsParentDirPath = topicsParentDirPath.replace("\\", "/");
        }
        File out = new File(this.outputDir, topicsAbsolutePath.replaceFirst(topicsParentDirPath, ""));
        if (f.isFile() && topicsAbsolutePath.contains("/templates/")) {
            out.getParentFile().mkdirs();
            Files.copy(f.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File c : files) {
                    this.processTopics(c);
                }
            }
        } else if (f.getName().endsWith(".adoc")) {
            out.getParentFile().mkdirs();
            String filePath = f.getAbsolutePath().replace(this.baseDir.getParent(), "").substring(1);
            if (this.isWindows()) {
                filePath = filePath.replace("\\", "/");
            }
            Object includeHeaderPath = filePath.substring(this.baseDir.getName().length() + 7);
            includeHeaderPath = ((String)includeHeaderPath).substring(0, ((String)includeHeaderPath).lastIndexOf(47));
            includeHeaderPath = ((String)includeHeaderPath).replaceAll("/[^/]+", "../");
            includeHeaderPath = (String)includeHeaderPath + "templates/header.adoc";
            String header = "\n\n:include_filename: " + filePath + "\ninclude::" + (String)includeHeaderPath + "[]\n\n";
            try (PrintStream ps = new PrintStream(new FileOutputStream(out));
                 BufferedReader br = new BufferedReader(new FileReader(f));){
                String l = br.readLine();
                while (l != null) {
                    ps.println(l);
                    if (l.startsWith("=")) break;
                    l = br.readLine();
                }
                ps.print(header);
                l = br.readLine();
                while (l != null) {
                    ps.println(l);
                    l = br.readLine();
                }
            }
        }
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().startsWith("windows");
    }
}

