/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mina.integration.beans.AbstractPropertyEditor;
import org.apache.mina.integration.beans.PropertyEditorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionEditor
extends AbstractPropertyEditor {
    static final Pattern ELEMENT = Pattern.compile("([,\\s]+)|(?<=\")((?:\\\\\"|\\\\'|\\\\\\\\|\\\\ |[^\"])*)(?=\")|(?<=')((?:\\\\\"|\\\\'|\\\\\\\\|\\\\ |[^'])*)(?=')|((?:[^\\\\\\s'\",]|\\\\ |\\\\\"|\\\\')+)");
    private final Class<?> elementType;

    public CollectionEditor(Class<?> elementType) {
        if (elementType == null) {
            throw new NullPointerException("elementType");
        }
        this.elementType = elementType;
        this.getElementEditor();
        this.setTrimText(false);
    }

    private PropertyEditor getElementEditor() {
        PropertyEditor e = PropertyEditorFactory.getInstance(this.elementType);
        if (e == null) {
            throw new IllegalArgumentException("No " + PropertyEditor.class.getSimpleName() + " found for " + this.elementType.getSimpleName() + '.');
        }
        return e;
    }

    @Override
    protected final String toText(Object value) {
        StringBuilder buf = new StringBuilder();
        for (Object v : (Collection)value) {
            PropertyEditor e;
            if (v == null) {
                v = this.defaultElement();
            }
            if ((e = PropertyEditorFactory.getInstance(v)) == null) {
                throw new IllegalArgumentException("No " + PropertyEditor.class.getSimpleName() + " found for " + v.getClass().getSimpleName() + '.');
            }
            e.setValue(v);
            String s = e.getAsText();
            buf.append(s);
            buf.append(", ");
        }
        if (buf.length() >= 2) {
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    @Override
    protected final Object toValue(String text) throws IllegalArgumentException {
        PropertyEditor e = this.getElementEditor();
        Collection<Object> answer = this.newCollection();
        Matcher m = ELEMENT.matcher(text);
        boolean matchedDelimiter = true;
        while (m.find()) {
            if (m.group(1) != null) {
                matchedDelimiter = true;
                continue;
            }
            if (!matchedDelimiter) {
                throw new IllegalArgumentException("No delimiter between elements: " + text);
            }
            e.setAsText(m.group());
            answer.add(e.getValue());
            matchedDelimiter = false;
            if (m.group(2) == null && m.group(3) == null) continue;
            m.region(m.end() + 1, m.regionEnd());
        }
        return answer;
    }

    protected Collection<Object> newCollection() {
        return new ArrayList<Object>();
    }

    protected Object defaultElement() {
        PropertyEditor e = PropertyEditorFactory.getInstance(this.elementType);
        if (e == null) {
            return null;
        }
        if (e instanceof AbstractPropertyEditor) {
            return ((AbstractPropertyEditor)e).defaultValue();
        }
        return null;
    }
}

