/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.collections;

import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.monitor.impl.LocalTopicStatsImpl;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTopic<E>
implements ITopic<E> {
    private final String name;
    private List<MessageListenerHolder> messageListenerHolders = new CopyOnWriteArrayList<MessageListenerHolder>();
    private final ThreadLocal<Boolean> isPublishing = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private LocalTopicStatsImpl localTopicStats;
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryTopic.class);

    public MemoryTopic(String name) {
        this.name = name;
        this.localTopicStats = new LocalTopicStatsImpl();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Created topic: " + this.getName());
        }
    }

    public String getPartitionKey() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return null;
    }

    public void publish(E o) {
        if (this.isPublishing.get().booleanValue()) {
            throw new UnsupportedOperationException("Cannot nest publishing operations");
        }
        this.isPublishing.set(true);
        Message m = new Message(this.getName(), o, System.nanoTime(), null);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Publishing message on topic: " + this.getName() + ", notifying " + this.messageListenerHolders.size() + " listener(s).");
        }
        for (MessageListenerHolder holder : this.messageListenerHolders) {
            try {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Publishing message on topic: " + this.getName() + ", notifying listener: " + holder.key + ".");
                }
                this.localTopicStats.incrementReceives();
                holder.listener.onMessage(m);
            }
            catch (Exception e) {
                LOGGER.debug("Message listener: " + holder.key + " failed.", (Throwable)e);
            }
        }
        this.localTopicStats.incrementPublishes();
        this.isPublishing.set(false);
    }

    public String addMessageListener(MessageListener<E> messageListener) {
        if (this.isPublishing.get().booleanValue()) {
            throw new UnsupportedOperationException("Cannot alter message listeners from publish operation");
        }
        if (messageListener == null) {
            throw new NullPointerException("messageListener must be not null");
        }
        String key = UUID.randomUUID().toString();
        MessageListenerHolder holder = new MessageListenerHolder(key, messageListener);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Adding message listener: " + key + " on topic: " + this.getName());
        }
        this.messageListenerHolders.add(holder);
        return key;
    }

    public boolean removeMessageListener(String s) {
        if (this.isPublishing.get().booleanValue()) {
            throw new UnsupportedOperationException("Cannot alter message listeners from publish operation");
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Removing message listener: " + s + " on topic: " + this.getName());
        }
        boolean result = false;
        for (MessageListenerHolder holder : this.messageListenerHolders) {
            if (!holder.key.equals(s)) continue;
            result = this.messageListenerHolders.remove(holder);
            break;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Removed message listener: " + s + " on topic: " + this.getName());
        }
        return result;
    }

    public LocalTopicStats getLocalTopicStats() {
        return this.localTopicStats;
    }

    public void destroy() {
        this.messageListenerHolders.clear();
        this.localTopicStats = new LocalTopicStatsImpl();
    }

    private final class MessageListenerHolder {
        private final String key;
        private final MessageListener<E> listener;

        public MessageListenerHolder(String key, MessageListener<E> listener) {
            this.key = key;
            this.listener = listener;
        }
    }
}

