/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.proxy;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.service.proxy.AbstractProxyAcceptHandler;
import org.kaazing.gateway.service.proxy.AbstractProxyHandler;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpConnectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpProxyServiceHandler
extends AbstractProxyAcceptHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"http.proxy");
    private static final String VIA_HEADER_VALUE = "1.1 kaazing";
    private URI connectURI;

    HttpProxyServiceHandler() {
    }

    protected AbstractProxyHandler createConnectHandler() {
        return new ConnectHandler();
    }

    public void initServiceConnectManager() {
        this.connectURI = (URI)this.getConnectURIs().iterator().next();
    }

    public void sessionOpened(IoSession session) {
        if (!session.isClosing()) {
            final HttpAcceptSession acceptSession = (HttpAcceptSession)session;
            ConnectFuture future = this.getServiceContext().connect(this.connectURI, (IoHandler)this.getConnectHandler(), (IoSessionInitializer)new IoSessionInitializer<ConnectFuture>(){

                public void initializeSession(IoSession session, ConnectFuture future) {
                    HttpConnectSession connectSession = (HttpConnectSession)session;
                    connectSession.setVersion(acceptSession.getVersion());
                    connectSession.setMethod(acceptSession.getMethod());
                    connectSession.setRequestURI(acceptSession.getRequestURI());
                    HttpProxyServiceHandler.this.processRequestHeaders(acceptSession, connectSession);
                }
            });
            future.addListener((IoFutureListener)new ConnectListener(acceptSession));
            super.sessionOpened((IoSession)acceptSession);
        }
    }

    private void processRequestHeaders(HttpAcceptSession acceptSession, HttpConnectSession connectSession) {
        Set<String> hopByHopHeaders = this.getHopByHopHeaders(acceptSession);
        boolean upgrade = false;
        String upgradeHeader = acceptSession.getReadHeader("Upgrade");
        if ("WebSocket".equalsIgnoreCase(upgradeHeader)) {
            upgrade = true;
            hopByHopHeaders.remove("Upgrade");
        }
        for (Map.Entry e : acceptSession.getReadHeaders().entrySet()) {
            String name = (String)e.getKey();
            for (String value : (List)e.getValue()) {
                if (hopByHopHeaders.contains(name)) continue;
                connectSession.addWriteHeader(name, value);
            }
        }
        if (upgrade) {
            connectSession.setWriteHeader("Connection", "Upgrade");
        } else {
            ResourceAddress address = connectSession.getRemoteAddress();
            if (!((Boolean)address.getOption(HttpResourceAddress.KEEP_ALIVE)).booleanValue()) {
                connectSession.setWriteHeader("Connection", "close");
            }
        }
        connectSession.addWriteHeader("Via", VIA_HEADER_VALUE);
    }

    private Set<String> getHopByHopHeaders(HttpAcceptSession acceptSession) {
        List<String> connectionHeaders = acceptSession.getReadHeaders("Connection");
        if (connectionHeaders == null) {
            connectionHeaders = Collections.emptyList();
        }
        TreeSet<String> hopByHopHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String conHeader : connectionHeaders) {
            hopByHopHeaders.add(conHeader);
        }
        hopByHopHeaders.add("Connection");
        return hopByHopHeaders;
    }

    private static class ConnectHandler
    extends AbstractProxyHandler {
        private ConnectHandler() {
        }

        public void messageReceived(IoSession session, Object message) {
            this.processResponseHeaders(session);
            super.messageReceived(session, message);
        }

        public void sessionClosed(IoSession session) {
            this.processResponseHeaders(session);
            super.sessionClosed(session);
        }

        private void processResponseHeaders(IoSession session) {
            HttpAcceptSession acceptSession;
            HttpConnectSession connectSession = (HttpConnectSession)session;
            AbstractProxyHandler.AttachedSessionManager attachedSessionManager = ConnectHandler.getAttachedSessionManager((IoSession)session);
            if (attachedSessionManager != null && (acceptSession = (HttpAcceptSession)attachedSessionManager.getAttachedSession()).getWrittenBytes() == 0L && !acceptSession.isCommitting() && !acceptSession.isClosing()) {
                acceptSession.setStatus(connectSession.getStatus());
                acceptSession.setReason(connectSession.getReason());
                acceptSession.setVersion(connectSession.getVersion());
                Map headers = connectSession.getReadHeaders();
                for (Map.Entry e : headers.entrySet()) {
                    String name = (String)e.getKey();
                    for (String value : (List)e.getValue()) {
                        if (name.equalsIgnoreCase("Connection") && value.equals("close")) continue;
                        acceptSession.addWriteHeader(name, value);
                    }
                }
            }
        }
    }

    private class ConnectListener
    implements IoFutureListener<ConnectFuture> {
        private final HttpAcceptSession acceptSession;

        ConnectListener(HttpAcceptSession acceptSession) {
            this.acceptSession = acceptSession;
        }

        public void operationComplete(ConnectFuture future) {
            if (future.isConnected()) {
                IoSession connectedSession = future.getSession();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Connected to " + HttpProxyServiceHandler.this.getConnectURIs().iterator().next() + " [" + this.acceptSession + "->" + connectedSession + "]");
                }
                if (this.acceptSession == null || this.acceptSession.isClosing()) {
                    connectedSession.close(true);
                } else {
                    AbstractProxyHandler.AttachedSessionManager attachedSessionManager = HttpProxyServiceHandler.this.attachSessions((IoSession)this.acceptSession, connectedSession);
                    HttpProxyServiceHandler.this.flushQueuedMessages((IoSession)this.acceptSession, attachedSessionManager);
                }
            } else {
                LOGGER.warn("Connection to " + HttpProxyServiceHandler.this.getConnectURIs().iterator().next() + " failed [" + this.acceptSession + "->]");
                this.acceptSession.close(true);
            }
        }
    }
}

